# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class EngagementContextList(ListResource):

    def __init__(self, version, flow_sid, engagement_sid):
        """
        Initialize the EngagementContextList

        :param Version version: Version that contains the resource
        :param flow_sid: Flow SID
        :param engagement_sid: Engagement SID

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextList
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextList
        """
        super(EngagementContextList, self).__init__(version)

        # Path Solution
        self._solution = {'flow_sid': flow_sid, 'engagement_sid': engagement_sid, }

    def get(self):
        """
        Constructs a EngagementContextContext

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        """
        return EngagementContextContext(
            self._version,
            flow_sid=self._solution['flow_sid'],
            engagement_sid=self._solution['engagement_sid'],
        )

    def __call__(self):
        """
        Constructs a EngagementContextContext

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        """
        return EngagementContextContext(
            self._version,
            flow_sid=self._solution['flow_sid'],
            engagement_sid=self._solution['engagement_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Studio.V1.EngagementContextList>'


class EngagementContextPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the EngagementContextPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param flow_sid: Flow SID
        :param engagement_sid: Engagement SID

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextPage
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextPage
        """
        super(EngagementContextPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of EngagementContextInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        """
        return EngagementContextInstance(
            self._version,
            payload,
            flow_sid=self._solution['flow_sid'],
            engagement_sid=self._solution['engagement_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Studio.V1.EngagementContextPage>'


class EngagementContextContext(InstanceContext):

    def __init__(self, version, flow_sid, engagement_sid):
        """
        Initialize the EngagementContextContext

        :param Version version: Version that contains the resource
        :param flow_sid: Flow SID
        :param engagement_sid: Engagement SID

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        """
        super(EngagementContextContext, self).__init__(version)

        # Path Solution
        self._solution = {'flow_sid': flow_sid, 'engagement_sid': engagement_sid, }
        self._uri = '/Flows/{flow_sid}/Engagements/{engagement_sid}/Context'.format(**self._solution)

    def fetch(self):
        """
        Fetch the EngagementContextInstance

        :returns: The fetched EngagementContextInstance
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return EngagementContextInstance(
            self._version,
            payload,
            flow_sid=self._solution['flow_sid'],
            engagement_sid=self._solution['engagement_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Studio.V1.EngagementContextContext {}>'.format(context)


class EngagementContextInstance(InstanceResource):

    def __init__(self, version, payload, flow_sid, engagement_sid):
        """
        Initialize the EngagementContextInstance

        :returns: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        """
        super(EngagementContextInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'context': payload.get('context'),
            'engagement_sid': payload.get('engagement_sid'),
            'flow_sid': payload.get('flow_sid'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'flow_sid': flow_sid, 'engagement_sid': engagement_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: EngagementContextContext for this EngagementContextInstance
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextContext
        """
        if self._context is None:
            self._context = EngagementContextContext(
                self._version,
                flow_sid=self._solution['flow_sid'],
                engagement_sid=self._solution['engagement_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: Account SID
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def context(self):
        """
        :returns: Flow state
        :rtype: dict
        """
        return self._properties['context']

    @property
    def engagement_sid(self):
        """
        :returns: Engagement SID
        :rtype: unicode
        """
        return self._properties['engagement_sid']

    @property
    def flow_sid(self):
        """
        :returns: Flow SID
        :rtype: unicode
        """
        return self._properties['flow_sid']

    @property
    def url(self):
        """
        :returns: The URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the EngagementContextInstance

        :returns: The fetched EngagementContextInstance
        :rtype: twilio.rest.studio.v1.flow.engagement.engagement_context.EngagementContextInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Studio.V1.EngagementContextInstance {}>'.format(context)
