# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class DayTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.preview.bulk_exports.exports("resource_type") \
                                            .days("day").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://preview.twilio.com/BulkExports/Exports/resource_type/Days/day',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "redirect_to": "https://www.twilio.com"
            }
            '''
        ))

        actual = self.client.preview.bulk_exports.exports("resource_type") \
                                                 .days("day").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.preview.bulk_exports.exports("resource_type") \
                                            .days.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://preview.twilio.com/BulkExports/Exports/resource_type/Days',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "days": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "days"
                }
            }
            '''
        ))

        actual = self.client.preview.bulk_exports.exports("resource_type") \
                                                 .days.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "days": [
                    {
                        "day": "2017-04-01",
                        "size": 100,
                        "resource_type": "Calls",
                        "create_date": "2017-04-02",
                        "friendly_name": "friendly_name"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "days"
                }
            }
            '''
        ))

        actual = self.client.preview.bulk_exports.exports("resource_type") \
                                                 .days.list()

        self.assertIsNotNone(actual)
