# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SecondaryAuthTokenTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.accounts.v1.secondary_auth_token().create()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://accounts.twilio.com/v1/AuthTokens/Secondary',
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-31T04:00:00Z",
                "date_updated": "2015-07-31T04:00:00Z",
                "secondary_auth_token": "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
                "url": "https://accounts.twilio.com/v1/AuthTokens/Secondary"
            }
            '''
        ))

        actual = self.client.accounts.v1.secondary_auth_token().create()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.accounts.v1.secondary_auth_token().delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://accounts.twilio.com/v1/AuthTokens/Secondary',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.accounts.v1.secondary_auth_token().delete()

        self.assertTrue(actual)
