This is a D binding to the Allegro 5 library: http://liballeg.org/

Should work fine with Allegro 5.2. Pretty much all of the cross-platform functions are bound.
Non cross-platform functions are absent, but they will be added eventually.

Tested with LDC and DMD compilers on Linux 64 bit and DMD on Windows 32 bit (XP). See general notes below to see how to use this
binding in your D program.

Installation
============

You have two options here. You can copy all the modules into your project, and just use them like that.
Alternatively, you can compile the binding into a static library for convenience:

Linux:

If you have LDC:

./build_lib_ldc.sh
./build_example_ldc.sh

If you have DMD:

./build_lib_dmd.sh
./build_example_dmd.sh

Windows:

If you have MinGW 4.5 (or earlier) compiled libraries:

build_lib_dmd.bat -version=ALLEGRO_MINGW_4_5

If you have MSVC/DMC/MinGW 4.6+ compiled DLLs:

build_lib_dmd.bat

Compiling the example
=====================

Linux:

If you have LDC:

./build_example_ldc.sh

If you have DMD:

./build_example_dmd.sh

Try the example by running:

./example

It should run and not crash.

Windows:

build_example_dmd.bat

Try the example by running:

example.exe

It should run and not crash.

Unstable API
============

If you want to use the unstable API, set the `ALLEGRO_UNSTABLE` version.

General Notes
=============

Using Allegro in a D program is a little bit different than using it in a C/C++ program. Specifically, you must run your code through the al_run_allegro function like so:

```d
import allegro5.allegro;

void main()
{
	al_run_allegro(
	{
		al_init()
		//your code goes here
		return 0;
	});
}
```

al_run_allegro will block until your code returns. On some platforms it will run your code in a different thread (you generally don't need to worry about this). This is done for cross-platform (specifically OSX) compatibility. Note that al_init/al_install_system should be called _inside_ the delegate you pass to al_run_allegro.

This binding is equipped with pragma(lib) constructs that should allow you to not have to specify which Allegro libraries to link to. It only works this way in D2, however. It expects libraries to be named the same way they are named by the build process or generated by the import library generator script (Windows only). Monolith libraries are not supported. This mechanism can be overriden by using the version ALLEGRO_NO_PRAGMA_LIB.

The module allegro5.d_util contains some utility functions for converting between D strings and ALLEGRO_USTR.

Windows Notes
=============

* You will need to generate the import libraries for Allegro's dll files using implib.exe that you can download here: http://ftp.digitalmars.com/bup.zip

    You can then use the create_import_libs.bat to create the import libraries. The script expects the Allegro DLLs to be in the same directory as the script. It also expects the implib to be callable from the command line (place it in PATH or into the directory alongside the script). E.g. if your directory had these DLL's in it:
    
    allegro-5.2.dll
    allegro_primitives-5.2.dll
    
    Running the script will produce these import libraries:
    
    allegro.lib
    allegro_primitives.lib
    
    If you're using dmd then when compiling you must pass the following linker flags to it for things to work properly:
    
    -L/SUBSYSTEM:WINDOWS:4.0
    
    If you want console output (this will also spawn the console whenever you run the program outside the command prompt) then use these flags:
    
    -L/SUBSYSTEM:CONSOLE:4.0

* Note that if you are using MinGW 4.5 (or earlier) or DMC compiled DLLs you will need to set the version to ALLEGRO_MINGW_4_5 when compiling your own programs as well as when building the library.

* You can obtain pre-built libraries at http://liballeg.org/download.html
