# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Accessory(Model):
    """Accessory item and corresponding confidence level.

    :param type: Type of an accessory. Possible values include: 'headWear',
     'glasses', 'mask'
    :type type: str or
     ~azure.cognitiveservices.vision.face.models.AccessoryType
    :param confidence: Confidence level of an accessory
    :type confidence: float
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'AccessoryType'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Accessory, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.confidence = kwargs.get('confidence', None)


class APIError(Model):
    """Error information returned by the API.

    :param error:
    :type error: ~azure.cognitiveservices.vision.face.models.Error
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(self, **kwargs):
        super(APIError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class APIErrorException(HttpOperationError):
    """Server responsed with exception of type: 'APIError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(APIErrorException, self).__init__(deserialize, response, 'APIError', *args)


class ApplySnapshotRequest(Model):
    """Request body for applying snapshot operation.

    All required parameters must be populated in order to send to Azure.

    :param object_id: Required. User specified target object id to be created
     from the snapshot.
    :type object_id: str
    :param mode: Snapshot applying mode. Currently only CreateNew is
     supported, which means the apply operation will fail if target
     subscription already contains an object of same type and using the same
     objectId. Users can specify the "objectId" in request body to avoid such
     conflicts. Possible values include: 'CreateNew'. Default value:
     "CreateNew" .
    :type mode: str or
     ~azure.cognitiveservices.vision.face.models.SnapshotApplyMode
    """

    _validation = {
        'object_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'SnapshotApplyMode'},
    }

    def __init__(self, **kwargs):
        super(ApplySnapshotRequest, self).__init__(**kwargs)
        self.object_id = kwargs.get('object_id', None)
        self.mode = kwargs.get('mode', "CreateNew")


class Blur(Model):
    """Properties describing any presence of blur within the image.

    :param blur_level: An enum value indicating level of blurriness. Possible
     values include: 'Low', 'Medium', 'High'
    :type blur_level: str or
     ~azure.cognitiveservices.vision.face.models.BlurLevel
    :param value: A number indicating level of blurriness ranging from 0 to 1.
    :type value: float
    """

    _attribute_map = {
        'blur_level': {'key': 'blurLevel', 'type': 'BlurLevel'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Blur, self).__init__(**kwargs)
        self.blur_level = kwargs.get('blur_level', None)
        self.value = kwargs.get('value', None)


class Coordinate(Model):
    """Coordinates within an image.

    All required parameters must be populated in order to send to Azure.

    :param x: Required. The horizontal component, in pixels.
    :type x: float
    :param y: Required. The vertical component, in pixels.
    :type y: float
    """

    _validation = {
        'x': {'required': True},
        'y': {'required': True},
    }

    _attribute_map = {
        'x': {'key': 'x', 'type': 'float'},
        'y': {'key': 'y', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Coordinate, self).__init__(**kwargs)
        self.x = kwargs.get('x', None)
        self.y = kwargs.get('y', None)


class DetectedFace(Model):
    """Detected Face object.

    All required parameters must be populated in order to send to Azure.

    :param face_id:
    :type face_id: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    :param face_rectangle: Required.
    :type face_rectangle:
     ~azure.cognitiveservices.vision.face.models.FaceRectangle
    :param face_landmarks:
    :type face_landmarks:
     ~azure.cognitiveservices.vision.face.models.FaceLandmarks
    :param face_attributes:
    :type face_attributes:
     ~azure.cognitiveservices.vision.face.models.FaceAttributes
    """

    _validation = {
        'face_rectangle': {'required': True},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
        'face_rectangle': {'key': 'faceRectangle', 'type': 'FaceRectangle'},
        'face_landmarks': {'key': 'faceLandmarks', 'type': 'FaceLandmarks'},
        'face_attributes': {'key': 'faceAttributes', 'type': 'FaceAttributes'},
    }

    def __init__(self, **kwargs):
        super(DetectedFace, self).__init__(**kwargs)
        self.face_id = kwargs.get('face_id', None)
        self.recognition_model = kwargs.get('recognition_model', "recognition_01")
        self.face_rectangle = kwargs.get('face_rectangle', None)
        self.face_landmarks = kwargs.get('face_landmarks', None)
        self.face_attributes = kwargs.get('face_attributes', None)


class Emotion(Model):
    """Properties describing facial emotion in form of confidence ranging from 0
    to 1.

    :param anger:
    :type anger: float
    :param contempt:
    :type contempt: float
    :param disgust:
    :type disgust: float
    :param fear:
    :type fear: float
    :param happiness:
    :type happiness: float
    :param neutral:
    :type neutral: float
    :param sadness:
    :type sadness: float
    :param surprise:
    :type surprise: float
    """

    _attribute_map = {
        'anger': {'key': 'anger', 'type': 'float'},
        'contempt': {'key': 'contempt', 'type': 'float'},
        'disgust': {'key': 'disgust', 'type': 'float'},
        'fear': {'key': 'fear', 'type': 'float'},
        'happiness': {'key': 'happiness', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'sadness': {'key': 'sadness', 'type': 'float'},
        'surprise': {'key': 'surprise', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Emotion, self).__init__(**kwargs)
        self.anger = kwargs.get('anger', None)
        self.contempt = kwargs.get('contempt', None)
        self.disgust = kwargs.get('disgust', None)
        self.fear = kwargs.get('fear', None)
        self.happiness = kwargs.get('happiness', None)
        self.neutral = kwargs.get('neutral', None)
        self.sadness = kwargs.get('sadness', None)
        self.surprise = kwargs.get('surprise', None)


class Error(Model):
    """Error body.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Exposure(Model):
    """Properties describing exposure level of the image.

    :param exposure_level: An enum value indicating level of exposure.
     Possible values include: 'UnderExposure', 'GoodExposure', 'OverExposure'
    :type exposure_level: str or
     ~azure.cognitiveservices.vision.face.models.ExposureLevel
    :param value: A number indicating level of exposure level ranging from 0
     to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75,
     1] is over exposure.
    :type value: float
    """

    _attribute_map = {
        'exposure_level': {'key': 'exposureLevel', 'type': 'ExposureLevel'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Exposure, self).__init__(**kwargs)
        self.exposure_level = kwargs.get('exposure_level', None)
        self.value = kwargs.get('value', None)


class FaceAttributes(Model):
    """Face Attributes.

    :param age: Age in years
    :type age: float
    :param gender: Possible gender of the face. Possible values include:
     'male', 'female'
    :type gender: str or ~azure.cognitiveservices.vision.face.models.Gender
    :param smile: Smile intensity, a number between [0,1]
    :type smile: float
    :param facial_hair: Properties describing facial hair attributes.
    :type facial_hair: ~azure.cognitiveservices.vision.face.models.FacialHair
    :param glasses: Glasses type if any of the face. Possible values include:
     'noGlasses', 'readingGlasses', 'sunglasses', 'swimmingGoggles'
    :type glasses: str or
     ~azure.cognitiveservices.vision.face.models.GlassesType
    :param head_pose: Properties indicating head pose of the face.
    :type head_pose: ~azure.cognitiveservices.vision.face.models.HeadPose
    :param emotion: Properties describing facial emotion in form of confidence
     ranging from 0 to 1.
    :type emotion: ~azure.cognitiveservices.vision.face.models.Emotion
    :param hair: Properties describing hair attributes.
    :type hair: ~azure.cognitiveservices.vision.face.models.Hair
    :param makeup: Properties describing present makeups on a given face.
    :type makeup: ~azure.cognitiveservices.vision.face.models.Makeup
    :param occlusion: Properties describing occlusions on a given face.
    :type occlusion: ~azure.cognitiveservices.vision.face.models.Occlusion
    :param accessories: Properties describing any accessories on a given face.
    :type accessories:
     list[~azure.cognitiveservices.vision.face.models.Accessory]
    :param blur: Properties describing any presence of blur within the image.
    :type blur: ~azure.cognitiveservices.vision.face.models.Blur
    :param exposure: Properties describing exposure level of the image.
    :type exposure: ~azure.cognitiveservices.vision.face.models.Exposure
    :param noise: Properties describing noise level of the image.
    :type noise: ~azure.cognitiveservices.vision.face.models.Noise
    """

    _attribute_map = {
        'age': {'key': 'age', 'type': 'float'},
        'gender': {'key': 'gender', 'type': 'Gender'},
        'smile': {'key': 'smile', 'type': 'float'},
        'facial_hair': {'key': 'facialHair', 'type': 'FacialHair'},
        'glasses': {'key': 'glasses', 'type': 'GlassesType'},
        'head_pose': {'key': 'headPose', 'type': 'HeadPose'},
        'emotion': {'key': 'emotion', 'type': 'Emotion'},
        'hair': {'key': 'hair', 'type': 'Hair'},
        'makeup': {'key': 'makeup', 'type': 'Makeup'},
        'occlusion': {'key': 'occlusion', 'type': 'Occlusion'},
        'accessories': {'key': 'accessories', 'type': '[Accessory]'},
        'blur': {'key': 'blur', 'type': 'Blur'},
        'exposure': {'key': 'exposure', 'type': 'Exposure'},
        'noise': {'key': 'noise', 'type': 'Noise'},
    }

    def __init__(self, **kwargs):
        super(FaceAttributes, self).__init__(**kwargs)
        self.age = kwargs.get('age', None)
        self.gender = kwargs.get('gender', None)
        self.smile = kwargs.get('smile', None)
        self.facial_hair = kwargs.get('facial_hair', None)
        self.glasses = kwargs.get('glasses', None)
        self.head_pose = kwargs.get('head_pose', None)
        self.emotion = kwargs.get('emotion', None)
        self.hair = kwargs.get('hair', None)
        self.makeup = kwargs.get('makeup', None)
        self.occlusion = kwargs.get('occlusion', None)
        self.accessories = kwargs.get('accessories', None)
        self.blur = kwargs.get('blur', None)
        self.exposure = kwargs.get('exposure', None)
        self.noise = kwargs.get('noise', None)


class FaceLandmarks(Model):
    """A collection of 27-point face landmarks pointing to the important positions
    of face components.

    :param pupil_left:
    :type pupil_left: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param pupil_right:
    :type pupil_right: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_tip:
    :type nose_tip: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param mouth_left:
    :type mouth_left: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param mouth_right:
    :type mouth_right: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eyebrow_left_outer:
    :type eyebrow_left_outer:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eyebrow_left_inner:
    :type eyebrow_left_inner:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_left_outer:
    :type eye_left_outer:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_left_top:
    :type eye_left_top: ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_left_bottom:
    :type eye_left_bottom:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_left_inner:
    :type eye_left_inner:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eyebrow_right_inner:
    :type eyebrow_right_inner:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eyebrow_right_outer:
    :type eyebrow_right_outer:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_right_inner:
    :type eye_right_inner:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_right_top:
    :type eye_right_top:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_right_bottom:
    :type eye_right_bottom:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param eye_right_outer:
    :type eye_right_outer:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_root_left:
    :type nose_root_left:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_root_right:
    :type nose_root_right:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_left_alar_top:
    :type nose_left_alar_top:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_right_alar_top:
    :type nose_right_alar_top:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_left_alar_out_tip:
    :type nose_left_alar_out_tip:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param nose_right_alar_out_tip:
    :type nose_right_alar_out_tip:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param upper_lip_top:
    :type upper_lip_top:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param upper_lip_bottom:
    :type upper_lip_bottom:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param under_lip_top:
    :type under_lip_top:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    :param under_lip_bottom:
    :type under_lip_bottom:
     ~azure.cognitiveservices.vision.face.models.Coordinate
    """

    _attribute_map = {
        'pupil_left': {'key': 'pupilLeft', 'type': 'Coordinate'},
        'pupil_right': {'key': 'pupilRight', 'type': 'Coordinate'},
        'nose_tip': {'key': 'noseTip', 'type': 'Coordinate'},
        'mouth_left': {'key': 'mouthLeft', 'type': 'Coordinate'},
        'mouth_right': {'key': 'mouthRight', 'type': 'Coordinate'},
        'eyebrow_left_outer': {'key': 'eyebrowLeftOuter', 'type': 'Coordinate'},
        'eyebrow_left_inner': {'key': 'eyebrowLeftInner', 'type': 'Coordinate'},
        'eye_left_outer': {'key': 'eyeLeftOuter', 'type': 'Coordinate'},
        'eye_left_top': {'key': 'eyeLeftTop', 'type': 'Coordinate'},
        'eye_left_bottom': {'key': 'eyeLeftBottom', 'type': 'Coordinate'},
        'eye_left_inner': {'key': 'eyeLeftInner', 'type': 'Coordinate'},
        'eyebrow_right_inner': {'key': 'eyebrowRightInner', 'type': 'Coordinate'},
        'eyebrow_right_outer': {'key': 'eyebrowRightOuter', 'type': 'Coordinate'},
        'eye_right_inner': {'key': 'eyeRightInner', 'type': 'Coordinate'},
        'eye_right_top': {'key': 'eyeRightTop', 'type': 'Coordinate'},
        'eye_right_bottom': {'key': 'eyeRightBottom', 'type': 'Coordinate'},
        'eye_right_outer': {'key': 'eyeRightOuter', 'type': 'Coordinate'},
        'nose_root_left': {'key': 'noseRootLeft', 'type': 'Coordinate'},
        'nose_root_right': {'key': 'noseRootRight', 'type': 'Coordinate'},
        'nose_left_alar_top': {'key': 'noseLeftAlarTop', 'type': 'Coordinate'},
        'nose_right_alar_top': {'key': 'noseRightAlarTop', 'type': 'Coordinate'},
        'nose_left_alar_out_tip': {'key': 'noseLeftAlarOutTip', 'type': 'Coordinate'},
        'nose_right_alar_out_tip': {'key': 'noseRightAlarOutTip', 'type': 'Coordinate'},
        'upper_lip_top': {'key': 'upperLipTop', 'type': 'Coordinate'},
        'upper_lip_bottom': {'key': 'upperLipBottom', 'type': 'Coordinate'},
        'under_lip_top': {'key': 'underLipTop', 'type': 'Coordinate'},
        'under_lip_bottom': {'key': 'underLipBottom', 'type': 'Coordinate'},
    }

    def __init__(self, **kwargs):
        super(FaceLandmarks, self).__init__(**kwargs)
        self.pupil_left = kwargs.get('pupil_left', None)
        self.pupil_right = kwargs.get('pupil_right', None)
        self.nose_tip = kwargs.get('nose_tip', None)
        self.mouth_left = kwargs.get('mouth_left', None)
        self.mouth_right = kwargs.get('mouth_right', None)
        self.eyebrow_left_outer = kwargs.get('eyebrow_left_outer', None)
        self.eyebrow_left_inner = kwargs.get('eyebrow_left_inner', None)
        self.eye_left_outer = kwargs.get('eye_left_outer', None)
        self.eye_left_top = kwargs.get('eye_left_top', None)
        self.eye_left_bottom = kwargs.get('eye_left_bottom', None)
        self.eye_left_inner = kwargs.get('eye_left_inner', None)
        self.eyebrow_right_inner = kwargs.get('eyebrow_right_inner', None)
        self.eyebrow_right_outer = kwargs.get('eyebrow_right_outer', None)
        self.eye_right_inner = kwargs.get('eye_right_inner', None)
        self.eye_right_top = kwargs.get('eye_right_top', None)
        self.eye_right_bottom = kwargs.get('eye_right_bottom', None)
        self.eye_right_outer = kwargs.get('eye_right_outer', None)
        self.nose_root_left = kwargs.get('nose_root_left', None)
        self.nose_root_right = kwargs.get('nose_root_right', None)
        self.nose_left_alar_top = kwargs.get('nose_left_alar_top', None)
        self.nose_right_alar_top = kwargs.get('nose_right_alar_top', None)
        self.nose_left_alar_out_tip = kwargs.get('nose_left_alar_out_tip', None)
        self.nose_right_alar_out_tip = kwargs.get('nose_right_alar_out_tip', None)
        self.upper_lip_top = kwargs.get('upper_lip_top', None)
        self.upper_lip_bottom = kwargs.get('upper_lip_bottom', None)
        self.under_lip_top = kwargs.get('under_lip_top', None)
        self.under_lip_bottom = kwargs.get('under_lip_bottom', None)


class NameAndUserDataContract(Model):
    """A combination of user defined name and user specified data for the person,
    largePersonGroup/personGroup, and largeFaceList/faceList.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAndUserDataContract, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.user_data = kwargs.get('user_data', None)


class MetaDataContract(NameAndUserDataContract):
    """A combination of user defined name and user specified data and recognition
    model name for largePersonGroup/personGroup, and largeFaceList/faceList.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetaDataContract, self).__init__(**kwargs)
        self.recognition_model = kwargs.get('recognition_model', "recognition_01")


class FaceList(MetaDataContract):
    """Face list object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    :param face_list_id: Required. FaceListId of the target face list.
    :type face_list_id: str
    :param persisted_faces: Persisted faces within the face list.
    :type persisted_faces:
     list[~azure.cognitiveservices.vision.face.models.PersistedFace]
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'face_list_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
        'face_list_id': {'key': 'faceListId', 'type': 'str'},
        'persisted_faces': {'key': 'persistedFaces', 'type': '[PersistedFace]'},
    }

    def __init__(self, **kwargs):
        super(FaceList, self).__init__(**kwargs)
        self.face_list_id = kwargs.get('face_list_id', None)
        self.persisted_faces = kwargs.get('persisted_faces', None)


class FaceRectangle(Model):
    """A rectangle within which a face can be found.

    All required parameters must be populated in order to send to Azure.

    :param width: Required. The width of the rectangle, in pixels.
    :type width: int
    :param height: Required. The height of the rectangle, in pixels.
    :type height: int
    :param left: Required. The distance from the left edge if the image to the
     left edge of the rectangle, in pixels.
    :type left: int
    :param top: Required. The distance from the top edge if the image to the
     top edge of the rectangle, in pixels.
    :type top: int
    """

    _validation = {
        'width': {'required': True},
        'height': {'required': True},
        'left': {'required': True},
        'top': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'left': {'key': 'left', 'type': 'int'},
        'top': {'key': 'top', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(FaceRectangle, self).__init__(**kwargs)
        self.width = kwargs.get('width', None)
        self.height = kwargs.get('height', None)
        self.left = kwargs.get('left', None)
        self.top = kwargs.get('top', None)


class FacialHair(Model):
    """Properties describing facial hair attributes.

    :param moustache:
    :type moustache: float
    :param beard:
    :type beard: float
    :param sideburns:
    :type sideburns: float
    """

    _attribute_map = {
        'moustache': {'key': 'moustache', 'type': 'float'},
        'beard': {'key': 'beard', 'type': 'float'},
        'sideburns': {'key': 'sideburns', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(FacialHair, self).__init__(**kwargs)
        self.moustache = kwargs.get('moustache', None)
        self.beard = kwargs.get('beard', None)
        self.sideburns = kwargs.get('sideburns', None)


class FindSimilarRequest(Model):
    """Request body for find similar operation.

    All required parameters must be populated in order to send to Azure.

    :param face_id: Required. FaceId of the query face. User needs to call
     Face - Detect first to get a valid faceId. Note that this faceId is not
     persisted and will expire 24 hours after the detection call
    :type face_id: str
    :param face_list_id: An existing user-specified unique candidate face
     list, created in Face List - Create a Face List. Face list contains a set
     of persistedFaceIds which are persisted and will never expire. Parameter
     faceListId, largeFaceListId and faceIds should not be provided at the same
     time.
    :type face_list_id: str
    :param large_face_list_id: An existing user-specified unique candidate
     large face list, created in LargeFaceList - Create. Large face list
     contains a set of persistedFaceIds which are persisted and will never
     expire. Parameter faceListId, largeFaceListId and faceIds should not be
     provided at the same time.
    :type large_face_list_id: str
    :param face_ids: An array of candidate faceIds. All of them are created by
     Face - Detect and the faceIds will expire 24 hours after the detection
     call. The number of faceIds is limited to 1000. Parameter faceListId,
     largeFaceListId and faceIds should not be provided at the same time.
    :type face_ids: list[str]
    :param max_num_of_candidates_returned: The number of top similar faces
     returned. The valid range is [1, 1000]. Default value: 20 .
    :type max_num_of_candidates_returned: int
    :param mode: Similar face searching mode. It can be "matchPerson" or
     "matchFace". Possible values include: 'matchPerson', 'matchFace'. Default
     value: "matchPerson" .
    :type mode: str or
     ~azure.cognitiveservices.vision.face.models.FindSimilarMatchMode
    """

    _validation = {
        'face_id': {'required': True},
        'face_list_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'large_face_list_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'face_ids': {'max_items': 1000},
        'max_num_of_candidates_returned': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'face_list_id': {'key': 'faceListId', 'type': 'str'},
        'large_face_list_id': {'key': 'largeFaceListId', 'type': 'str'},
        'face_ids': {'key': 'faceIds', 'type': '[str]'},
        'max_num_of_candidates_returned': {'key': 'maxNumOfCandidatesReturned', 'type': 'int'},
        'mode': {'key': 'mode', 'type': 'FindSimilarMatchMode'},
    }

    def __init__(self, **kwargs):
        super(FindSimilarRequest, self).__init__(**kwargs)
        self.face_id = kwargs.get('face_id', None)
        self.face_list_id = kwargs.get('face_list_id', None)
        self.large_face_list_id = kwargs.get('large_face_list_id', None)
        self.face_ids = kwargs.get('face_ids', None)
        self.max_num_of_candidates_returned = kwargs.get('max_num_of_candidates_returned', 20)
        self.mode = kwargs.get('mode', "matchPerson")


class GroupRequest(Model):
    """Request body for group request.

    All required parameters must be populated in order to send to Azure.

    :param face_ids: Required. Array of candidate faceId created by Face -
     Detect. The maximum is 1000 faces
    :type face_ids: list[str]
    """

    _validation = {
        'face_ids': {'required': True, 'max_items': 1000},
    }

    _attribute_map = {
        'face_ids': {'key': 'faceIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(GroupRequest, self).__init__(**kwargs)
        self.face_ids = kwargs.get('face_ids', None)


class GroupResult(Model):
    """An array of face groups based on face similarity.

    All required parameters must be populated in order to send to Azure.

    :param groups: Required. A partition of the original faces based on face
     similarity. Groups are ranked by number of faces
    :type groups: list[list[str]]
    :param messy_group: Face ids array of faces that cannot find any similar
     faces from original faces.
    :type messy_group: list[str]
    """

    _validation = {
        'groups': {'required': True},
    }

    _attribute_map = {
        'groups': {'key': 'groups', 'type': '[[str]]'},
        'messy_group': {'key': 'messyGroup', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(GroupResult, self).__init__(**kwargs)
        self.groups = kwargs.get('groups', None)
        self.messy_group = kwargs.get('messy_group', None)


class Hair(Model):
    """Properties describing hair attributes.

    :param bald: A number describing confidence level of whether the person is
     bald.
    :type bald: float
    :param invisible: A boolean value describing whether the hair is visible
     in the image.
    :type invisible: bool
    :param hair_color: An array of candidate colors and confidence level in
     the presence of each.
    :type hair_color:
     list[~azure.cognitiveservices.vision.face.models.HairColor]
    """

    _attribute_map = {
        'bald': {'key': 'bald', 'type': 'float'},
        'invisible': {'key': 'invisible', 'type': 'bool'},
        'hair_color': {'key': 'hairColor', 'type': '[HairColor]'},
    }

    def __init__(self, **kwargs):
        super(Hair, self).__init__(**kwargs)
        self.bald = kwargs.get('bald', None)
        self.invisible = kwargs.get('invisible', None)
        self.hair_color = kwargs.get('hair_color', None)


class HairColor(Model):
    """Hair color and associated confidence.

    :param color: Name of the hair color. Possible values include: 'unknown',
     'white', 'gray', 'blond', 'brown', 'red', 'black', 'other'
    :type color: str or
     ~azure.cognitiveservices.vision.face.models.HairColorType
    :param confidence: Confidence level of the color
    :type confidence: float
    """

    _attribute_map = {
        'color': {'key': 'color', 'type': 'HairColorType'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(HairColor, self).__init__(**kwargs)
        self.color = kwargs.get('color', None)
        self.confidence = kwargs.get('confidence', None)


class HeadPose(Model):
    """Properties indicating head pose of the face.

    :param roll:
    :type roll: float
    :param yaw:
    :type yaw: float
    :param pitch:
    :type pitch: float
    """

    _attribute_map = {
        'roll': {'key': 'roll', 'type': 'float'},
        'yaw': {'key': 'yaw', 'type': 'float'},
        'pitch': {'key': 'pitch', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(HeadPose, self).__init__(**kwargs)
        self.roll = kwargs.get('roll', None)
        self.yaw = kwargs.get('yaw', None)
        self.pitch = kwargs.get('pitch', None)


class IdentifyCandidate(Model):
    """All possible faces that may qualify.

    All required parameters must be populated in order to send to Azure.

    :param person_id: Required. Id of candidate
    :type person_id: str
    :param confidence: Required. Confidence threshold of identification, used
     to judge whether one face belong to one person. The range of
     confidenceThreshold is [0, 1] (default specified by algorithm).
    :type confidence: float
    """

    _validation = {
        'person_id': {'required': True},
        'confidence': {'required': True},
    }

    _attribute_map = {
        'person_id': {'key': 'personId', 'type': 'str'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(IdentifyCandidate, self).__init__(**kwargs)
        self.person_id = kwargs.get('person_id', None)
        self.confidence = kwargs.get('confidence', None)


class IdentifyRequest(Model):
    """Request body for identify face operation.

    All required parameters must be populated in order to send to Azure.

    :param face_ids: Required. Array of query faces faceIds, created by the
     Face - Detect. Each of the faces are identified independently. The valid
     number of faceIds is between [1, 10].
    :type face_ids: list[str]
    :param person_group_id: PersonGroupId of the target person group, created
     by PersonGroup - Create. Parameter personGroupId and largePersonGroupId
     should not be provided at the same time.
    :type person_group_id: str
    :param large_person_group_id: LargePersonGroupId of the target large
     person group, created by LargePersonGroup - Create. Parameter
     personGroupId and largePersonGroupId should not be provided at the same
     time.
    :type large_person_group_id: str
    :param max_num_of_candidates_returned: The range of
     maxNumOfCandidatesReturned is between 1 and 5 (default is 1). Default
     value: 1 .
    :type max_num_of_candidates_returned: int
    :param confidence_threshold: Confidence threshold of identification, used
     to judge whether one face belong to one person. The range of
     confidenceThreshold is [0, 1] (default specified by algorithm).
    :type confidence_threshold: float
    """

    _validation = {
        'face_ids': {'required': True, 'max_items': 10},
        'person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'large_person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'max_num_of_candidates_returned': {'maximum': 5, 'minimum': 1},
    }

    _attribute_map = {
        'face_ids': {'key': 'faceIds', 'type': '[str]'},
        'person_group_id': {'key': 'personGroupId', 'type': 'str'},
        'large_person_group_id': {'key': 'largePersonGroupId', 'type': 'str'},
        'max_num_of_candidates_returned': {'key': 'maxNumOfCandidatesReturned', 'type': 'int'},
        'confidence_threshold': {'key': 'confidenceThreshold', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(IdentifyRequest, self).__init__(**kwargs)
        self.face_ids = kwargs.get('face_ids', None)
        self.person_group_id = kwargs.get('person_group_id', None)
        self.large_person_group_id = kwargs.get('large_person_group_id', None)
        self.max_num_of_candidates_returned = kwargs.get('max_num_of_candidates_returned', 1)
        self.confidence_threshold = kwargs.get('confidence_threshold', None)


class IdentifyResult(Model):
    """Response body for identify face operation.

    All required parameters must be populated in order to send to Azure.

    :param face_id: Required. FaceId of the query face
    :type face_id: str
    :param candidates: Required. Identified person candidates for that face
     (ranked by confidence). Array size should be no larger than input
     maxNumOfCandidatesReturned. If no person is identified, will return an
     empty array.
    :type candidates:
     list[~azure.cognitiveservices.vision.face.models.IdentifyCandidate]
    """

    _validation = {
        'face_id': {'required': True},
        'candidates': {'required': True},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'candidates': {'key': 'candidates', 'type': '[IdentifyCandidate]'},
    }

    def __init__(self, **kwargs):
        super(IdentifyResult, self).__init__(**kwargs)
        self.face_id = kwargs.get('face_id', None)
        self.candidates = kwargs.get('candidates', None)


class ImageUrl(Model):
    """ImageUrl.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. Publicly reachable URL of an image
    :type url: str
    """

    _validation = {
        'url': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageUrl, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class LargeFaceList(MetaDataContract):
    """Large face list object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    :param large_face_list_id: Required. LargeFaceListId of the target large
     face list.
    :type large_face_list_id: str
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'large_face_list_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
        'large_face_list_id': {'key': 'largeFaceListId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LargeFaceList, self).__init__(**kwargs)
        self.large_face_list_id = kwargs.get('large_face_list_id', None)


class LargePersonGroup(MetaDataContract):
    """Large person group object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    :param large_person_group_id: Required. LargePersonGroupId of the target
     large person groups
    :type large_person_group_id: str
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'large_person_group_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
        'large_person_group_id': {'key': 'largePersonGroupId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LargePersonGroup, self).__init__(**kwargs)
        self.large_person_group_id = kwargs.get('large_person_group_id', None)


class Makeup(Model):
    """Properties describing present makeups on a given face.

    :param eye_makeup: A boolean value describing whether eye makeup is
     present on a face.
    :type eye_makeup: bool
    :param lip_makeup: A boolean value describing whether lip makeup is
     present on a face.
    :type lip_makeup: bool
    """

    _attribute_map = {
        'eye_makeup': {'key': 'eyeMakeup', 'type': 'bool'},
        'lip_makeup': {'key': 'lipMakeup', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Makeup, self).__init__(**kwargs)
        self.eye_makeup = kwargs.get('eye_makeup', None)
        self.lip_makeup = kwargs.get('lip_makeup', None)


class Noise(Model):
    """Properties describing noise level of the image.

    :param noise_level: An enum value indicating level of noise. Possible
     values include: 'Low', 'Medium', 'High'
    :type noise_level: str or
     ~azure.cognitiveservices.vision.face.models.NoiseLevel
    :param value: A number indicating level of noise level ranging from 0 to
     1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75, 1]
     is over exposure. [0, 0.3) is low noise level. [0.3, 0.7) is medium noise
     level. [0.7, 1] is high noise level.
    :type value: float
    """

    _attribute_map = {
        'noise_level': {'key': 'noiseLevel', 'type': 'NoiseLevel'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Noise, self).__init__(**kwargs)
        self.noise_level = kwargs.get('noise_level', None)
        self.value = kwargs.get('value', None)


class Occlusion(Model):
    """Properties describing occlusions on a given face.

    :param forehead_occluded: A boolean value indicating whether forehead is
     occluded.
    :type forehead_occluded: bool
    :param eye_occluded: A boolean value indicating whether eyes are occluded.
    :type eye_occluded: bool
    :param mouth_occluded: A boolean value indicating whether the mouth is
     occluded.
    :type mouth_occluded: bool
    """

    _attribute_map = {
        'forehead_occluded': {'key': 'foreheadOccluded', 'type': 'bool'},
        'eye_occluded': {'key': 'eyeOccluded', 'type': 'bool'},
        'mouth_occluded': {'key': 'mouthOccluded', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Occlusion, self).__init__(**kwargs)
        self.forehead_occluded = kwargs.get('forehead_occluded', None)
        self.eye_occluded = kwargs.get('eye_occluded', None)
        self.mouth_occluded = kwargs.get('mouth_occluded', None)


class OperationStatus(Model):
    """Operation status object. Operation refers to the asynchronous backend task
    including taking a snapshot and applying a snapshot.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Operation status: notstarted, running, succeeded,
     failed. If the operation is requested and waiting to perform, the status
     is notstarted. If the operation is ongoing in backend, the status is
     running. Status succeeded means the operation is completed successfully,
     specifically for snapshot taking operation, it illustrates the snapshot is
     well taken and ready to apply, and for snapshot applying operation, it
     presents the target object has finished creating by the snapshot and ready
     to be used. Status failed is often caused by editing the source object
     while taking the snapshot or editing the target object while applying the
     snapshot before completion, see the field "message" to check the failure
     reason. Possible values include: 'notstarted', 'running', 'succeeded',
     'failed'
    :type status: str or
     ~azure.cognitiveservices.vision.face.models.OperationStatusType
    :param created_time: Required. A combined UTC date and time string that
     describes the time when the operation (take or apply a snapshot) is
     requested. E.g. 2018-12-25T11:41:02.2331413Z.
    :type created_time: datetime
    :param last_action_time: A combined UTC date and time string that
     describes the last time the operation (take or apply a snapshot) is
     actively migrating data. The lastActionTime will keep increasing until the
     operation finishes. E.g. 2018-12-25T11:51:27.8705696Z.
    :type last_action_time: datetime
    :param resource_location: When the operation succeeds successfully, for
     snapshot taking operation the snapshot id will be included in this field,
     and for snapshot applying operation, the path to get the target object
     will be returned in this field.
    :type resource_location: str
    :param message: Show failure message when operation fails (omitted when
     operation succeeds).
    :type message: str
    """

    _validation = {
        'status': {'required': True},
        'created_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'OperationStatusType'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_action_time': {'key': 'lastActionTime', 'type': 'iso-8601'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationStatus, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.created_time = kwargs.get('created_time', None)
        self.last_action_time = kwargs.get('last_action_time', None)
        self.resource_location = kwargs.get('resource_location', None)
        self.message = kwargs.get('message', None)


class PersistedFace(Model):
    """PersonFace object.

    All required parameters must be populated in order to send to Azure.

    :param persisted_face_id: Required. The persistedFaceId of the target
     face, which is persisted and will not expire. Different from faceId
     created by Face - Detect and will expire in 24 hours after the detection
     call.
    :type persisted_face_id: str
    :param user_data: User-provided data attached to the face. The size limit
     is 1KB.
    :type user_data: str
    """

    _validation = {
        'persisted_face_id': {'required': True},
        'user_data': {'max_length': 1024},
    }

    _attribute_map = {
        'persisted_face_id': {'key': 'persistedFaceId', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PersistedFace, self).__init__(**kwargs)
        self.persisted_face_id = kwargs.get('persisted_face_id', None)
        self.user_data = kwargs.get('user_data', None)


class Person(NameAndUserDataContract):
    """Person object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param person_id: Required. PersonId of the target face list.
    :type person_id: str
    :param persisted_face_ids: PersistedFaceIds of registered faces in the
     person. These persistedFaceIds are returned from Person - Add a Person
     Face, and will not expire.
    :type persisted_face_ids: list[str]
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'person_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'person_id': {'key': 'personId', 'type': 'str'},
        'persisted_face_ids': {'key': 'persistedFaceIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(Person, self).__init__(**kwargs)
        self.person_id = kwargs.get('person_id', None)
        self.persisted_face_ids = kwargs.get('persisted_face_ids', None)


class PersonGroup(MetaDataContract):
    """Person group object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02', 'recognition_03'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    :param person_group_id: Required. PersonGroupId of the target person
     group.
    :type person_group_id: str
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'person_group_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
        'person_group_id': {'key': 'personGroupId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PersonGroup, self).__init__(**kwargs)
        self.person_group_id = kwargs.get('person_group_id', None)


class SimilarFace(Model):
    """Response body for find similar face operation.

    All required parameters must be populated in order to send to Azure.

    :param face_id: FaceId of candidate face when find by faceIds. faceId is
     created by Face - Detect and will expire 24 hours after the detection call
    :type face_id: str
    :param persisted_face_id: PersistedFaceId of candidate face when find by
     faceListId. persistedFaceId in face list is persisted and will not expire.
     As showed in below response
    :type persisted_face_id: str
    :param confidence: Required. Similarity confidence of the candidate face.
     The higher confidence, the more similar. Range between [0,1].
    :type confidence: float
    """

    _validation = {
        'confidence': {'required': True},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'persisted_face_id': {'key': 'persistedFaceId', 'type': 'str'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(SimilarFace, self).__init__(**kwargs)
        self.face_id = kwargs.get('face_id', None)
        self.persisted_face_id = kwargs.get('persisted_face_id', None)
        self.confidence = kwargs.get('confidence', None)


class Snapshot(Model):
    """Snapshot object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Snapshot id.
    :type id: str
    :param account: Required. Azure Cognitive Service Face account id of the
     subscriber who created the snapshot by Snapshot - Take.
    :type account: str
    :param type: Required. Type of the source object in the snapshot,
     specified by the subscriber who created the snapshot when calling Snapshot
     - Take. Currently FaceList, PersonGroup, LargeFaceList and
     LargePersonGroup are supported. Possible values include: 'FaceList',
     'LargeFaceList', 'LargePersonGroup', 'PersonGroup'
    :type type: str or
     ~azure.cognitiveservices.vision.face.models.SnapshotObjectType
    :param apply_scope: Required. Array of the target Face subscription ids
     for the snapshot, specified by the user who created the snapshot when
     calling Snapshot - Take. For each snapshot, only subscriptions included in
     the applyScope of Snapshot - Take can apply it.
    :type apply_scope: list[str]
    :param user_data: User specified data about the snapshot for any purpose.
     Length should not exceed 16KB.
    :type user_data: str
    :param created_time: Required. A combined UTC date and time string that
     describes the created time of the snapshot. E.g.
     2018-12-25T11:41:02.2331413Z.
    :type created_time: datetime
    :param last_update_time: Required. A combined UTC date and time string
     that describes the last time when the snapshot was created or updated by
     Snapshot - Update. E.g. 2018-12-25T11:51:27.8705696Z.
    :type last_update_time: datetime
    """

    _validation = {
        'id': {'required': True},
        'account': {'required': True},
        'type': {'required': True},
        'apply_scope': {'required': True},
        'user_data': {'max_length': 16384},
        'created_time': {'required': True},
        'last_update_time': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'account': {'key': 'account', 'type': 'str'},
        'type': {'key': 'type', 'type': 'SnapshotObjectType'},
        'apply_scope': {'key': 'applyScope', 'type': '[str]'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(Snapshot, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.account = kwargs.get('account', None)
        self.type = kwargs.get('type', None)
        self.apply_scope = kwargs.get('apply_scope', None)
        self.user_data = kwargs.get('user_data', None)
        self.created_time = kwargs.get('created_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)


class TakeSnapshotRequest(Model):
    """Request body for taking snapshot operation.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. User specified type for the source object to take
     snapshot from. Currently FaceList, PersonGroup, LargeFaceList and
     LargePersonGroup are supported. Possible values include: 'FaceList',
     'LargeFaceList', 'LargePersonGroup', 'PersonGroup'
    :type type: str or
     ~azure.cognitiveservices.vision.face.models.SnapshotObjectType
    :param object_id: Required. User specified source object id to take
     snapshot from.
    :type object_id: str
    :param apply_scope: Required. User specified array of target Face
     subscription ids for the snapshot. For each snapshot, only subscriptions
     included in the applyScope of Snapshot - Take can apply it.
    :type apply_scope: list[str]
    :param user_data: User specified data about the snapshot for any purpose.
     Length should not exceed 16KB.
    :type user_data: str
    """

    _validation = {
        'type': {'required': True},
        'object_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'apply_scope': {'required': True},
        'user_data': {'max_length': 16384},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'SnapshotObjectType'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'apply_scope': {'key': 'applyScope', 'type': '[str]'},
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TakeSnapshotRequest, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.object_id = kwargs.get('object_id', None)
        self.apply_scope = kwargs.get('apply_scope', None)
        self.user_data = kwargs.get('user_data', None)


class TrainingStatus(Model):
    """Training status object.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Training status: notstarted, running, succeeded,
     failed. If the training process is waiting to perform, the status is
     notstarted. If the training is ongoing, the status is running. Status
     succeed means this person group or large person group is ready for Face -
     Identify, or this large face list is ready for Face - Find Similar. Status
     failed is often caused by no person or no persisted face exist in the
     person group or large person group, or no persisted face exist in the
     large face list. Possible values include: 'nonstarted', 'running',
     'succeeded', 'failed'
    :type status: str or
     ~azure.cognitiveservices.vision.face.models.TrainingStatusType
    :param created: Required. A combined UTC date and time string that
     describes the created time of the person group, large person group or
     large face list.
    :type created: datetime
    :param last_action: A combined UTC date and time string that describes the
     last modify time of the person group, large person group or large face
     list, could be null value when the group is not successfully trained.
    :type last_action: datetime
    :param last_successful_training: A combined UTC date and time string that
     describes the last successful training time of the person group, large
     person group or large face list.
    :type last_successful_training: datetime
    :param message: Show failure message when training failed (omitted when
     training succeed).
    :type message: str
    """

    _validation = {
        'status': {'required': True},
        'created': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'TrainingStatusType'},
        'created': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'last_successful_training': {'key': 'lastSuccessfulTrainingDateTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrainingStatus, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.created = kwargs.get('created', None)
        self.last_action = kwargs.get('last_action', None)
        self.last_successful_training = kwargs.get('last_successful_training', None)
        self.message = kwargs.get('message', None)


class UpdateFaceRequest(Model):
    """Request to update face data.

    :param user_data: User-provided data attached to the face. The size limit
     is 1KB.
    :type user_data: str
    """

    _validation = {
        'user_data': {'max_length': 1024},
    }

    _attribute_map = {
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpdateFaceRequest, self).__init__(**kwargs)
        self.user_data = kwargs.get('user_data', None)


class UpdateSnapshotRequest(Model):
    """Request body for updating a snapshot, with a combination of user defined
    apply scope and user specified data.

    :param apply_scope: Array of the target Face subscription ids for the
     snapshot, specified by the user who created the snapshot when calling
     Snapshot - Take. For each snapshot, only subscriptions included in the
     applyScope of Snapshot - Take can apply it.
    :type apply_scope: list[str]
    :param user_data: User specified data about the snapshot for any purpose.
     Length should not exceed 16KB.
    :type user_data: str
    """

    _validation = {
        'user_data': {'max_length': 16384},
    }

    _attribute_map = {
        'apply_scope': {'key': 'applyScope', 'type': '[str]'},
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpdateSnapshotRequest, self).__init__(**kwargs)
        self.apply_scope = kwargs.get('apply_scope', None)
        self.user_data = kwargs.get('user_data', None)


class VerifyFaceToFaceRequest(Model):
    """Request body for face to face verification.

    All required parameters must be populated in order to send to Azure.

    :param face_id1: Required. FaceId of the first face, comes from Face -
     Detect
    :type face_id1: str
    :param face_id2: Required. FaceId of the second face, comes from Face -
     Detect
    :type face_id2: str
    """

    _validation = {
        'face_id1': {'required': True},
        'face_id2': {'required': True},
    }

    _attribute_map = {
        'face_id1': {'key': 'faceId1', 'type': 'str'},
        'face_id2': {'key': 'faceId2', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerifyFaceToFaceRequest, self).__init__(**kwargs)
        self.face_id1 = kwargs.get('face_id1', None)
        self.face_id2 = kwargs.get('face_id2', None)


class VerifyFaceToPersonRequest(Model):
    """Request body for face to person verification.

    All required parameters must be populated in order to send to Azure.

    :param face_id: Required. FaceId of the face, comes from Face - Detect
    :type face_id: str
    :param person_group_id: Using existing personGroupId and personId for fast
     loading a specified person. personGroupId is created in PersonGroup -
     Create. Parameter personGroupId and largePersonGroupId should not be
     provided at the same time.
    :type person_group_id: str
    :param large_person_group_id: Using existing largePersonGroupId and
     personId for fast loading a specified person. largePersonGroupId is
     created in LargePersonGroup - Create. Parameter personGroupId and
     largePersonGroupId should not be provided at the same time.
    :type large_person_group_id: str
    :param person_id: Required. Specify a certain person in a person group or
     a large person group. personId is created in PersonGroup Person - Create
     or LargePersonGroup Person - Create.
    :type person_id: str
    """

    _validation = {
        'face_id': {'required': True},
        'person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'large_person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'person_id': {'required': True},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'person_group_id': {'key': 'personGroupId', 'type': 'str'},
        'large_person_group_id': {'key': 'largePersonGroupId', 'type': 'str'},
        'person_id': {'key': 'personId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerifyFaceToPersonRequest, self).__init__(**kwargs)
        self.face_id = kwargs.get('face_id', None)
        self.person_group_id = kwargs.get('person_group_id', None)
        self.large_person_group_id = kwargs.get('large_person_group_id', None)
        self.person_id = kwargs.get('person_id', None)


class VerifyResult(Model):
    """Result of the verify operation.

    All required parameters must be populated in order to send to Azure.

    :param is_identical: Required. True if the two faces belong to the same
     person or the face belongs to the person, otherwise false.
    :type is_identical: bool
    :param confidence: Required. A number indicates the similarity confidence
     of whether two faces belong to the same person, or whether the face
     belongs to the person. By default, isIdentical is set to True if
     similarity confidence is greater than or equal to 0.5. This is useful for
     advanced users to override "isIdentical" and fine-tune the result on their
     own data.
    :type confidence: float
    """

    _validation = {
        'is_identical': {'required': True},
        'confidence': {'required': True},
    }

    _attribute_map = {
        'is_identical': {'key': 'isIdentical', 'type': 'bool'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(VerifyResult, self).__init__(**kwargs)
        self.is_identical = kwargs.get('is_identical', None)
        self.confidence = kwargs.get('confidence', None)
