--TEST--
https://github.com/sebastianbergmann/phpunit/issues/1351
--SKIPIF--
<?php declare(strict_types=1);
if (!extension_loaded('pdo') || !in_array('sqlite', PDO::getAvailableDrivers())) {
    print 'skip: PDO_SQLITE is required';
}
--FILE--
<?php declare(strict_types=1);
$_SERVER['argv'][] = '--do-not-cache-result';
$_SERVER['argv'][] = '--no-configuration';
$_SERVER['argv'][] = '--process-isolation';
$_SERVER['argv'][] = __DIR__ . '/1351/Issue1351Test.php';

require __DIR__ . '/../../../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

F.E.E                                                               5 / 5 (100%)

Time: %s, Memory: %s

There were 2 errors:

1) Issue1351Test::testExceptionPre
RuntimeException: Expected rethrown exception.
%A
Caused by
LogicException: Expected exception.
%A

2) Issue1351Test::testPhpCoreLanguageException
PDOException: SQLSTATE[HY000]: General error: 1 no such table: php_wtf
%A

--

There was 1 failure:

1) Issue1351Test::testFailurePre
Expected failure.
%A
ERRORS!
Tests: 5, Assertions: 5, Errors: 2, Failures: 1.
