/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.tuckey.web.filters.urlrewrite.ConditionMatch;
import org.tuckey.web.filters.urlrewrite.TypeConverter;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.NumberUtils;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public final class Condition
extends TypeConverter {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$Condition == null ? (class$org$tuckey$web$filters$urlrewrite$Condition = Condition.class$("org.tuckey.web.filters.urlrewrite.Condition")) : class$org$tuckey$web$filters$urlrewrite$Condition);
    private boolean caseSensitive = false;
    private int id = 0;
    private Pattern pattern;
    private String name;
    private short operator;
    private String strValue;
    private long numericValue = 0L;
    private boolean processNextOr = false;
    private boolean valid = false;
    private boolean initialised = false;
    private static final short OPERATOR_EQUAL = 1;
    private static final short OPERATOR_NOT_EQUAL = 2;
    private static final short OPERATOR_GREATER_THAN = 3;
    private static final short OPERATOR_LESS_THAN = 4;
    private static final short OPERATOR_GREATER_THAN_OR_EQUAL = 5;
    private static final short OPERATOR_LESS_THAN_OR_EQUAL = 6;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$Condition;

    public boolean matches(HttpServletRequest hsRequest) {
        return this.getConditionMatch(hsRequest) != null;
    }

    public ConditionMatch getConditionMatch(HttpServletRequest hsRequest) {
        if (!this.initialised) {
            log.debug("condition not initialised skipping");
            return null;
        }
        if (!this.valid) {
            log.debug("condition not valid skipping");
            return null;
        }
        switch (this.type) {
            case 4: {
                return this.evaluateNumericCondition(System.currentTimeMillis());
            }
            case 5: {
                return this.evaluateCalendarCondition(1);
            }
            case 6: {
                return this.evaluateCalendarCondition(2);
            }
            case 7: {
                return this.evaluateCalendarCondition(5);
            }
            case 8: {
                return this.evaluateCalendarCondition(7);
            }
            case 9: {
                return this.evaluateCalendarCondition(9);
            }
            case 10: {
                return this.evaluateCalendarCondition(11);
            }
            case 11: {
                return this.evaluateCalendarCondition(12);
            }
            case 12: {
                return this.evaluateCalendarCondition(13);
            }
            case 13: {
                return this.evaluateCalendarCondition(14);
            }
            case 14: {
                return this.evaluateAttributeCondition(this.name == null ? null : hsRequest.getAttribute(this.name));
            }
            case 15: {
                return this.evaluateStringCondition(hsRequest.getAuthType());
            }
            case 16: {
                return this.evaluateStringCondition(hsRequest.getCharacterEncoding());
            }
            case 17: {
                return this.evaluateNumericCondition(hsRequest.getContentLength());
            }
            case 18: {
                return this.evaluateStringCondition(hsRequest.getContentType());
            }
            case 19: {
                return this.evaluateStringCondition(hsRequest.getContextPath());
            }
            case 20: {
                return this.evaluateCookieCondition(hsRequest.getCookies(), this.name);
            }
            case 39: {
                return this.evaluateNumericCondition(hsRequest.getLocalPort());
            }
            case 21: {
                return this.evaluateStringCondition(hsRequest.getMethod());
            }
            case 22: {
                return this.evaluateStringCondition(this.name == null ? null : hsRequest.getParameter(this.name));
            }
            case 23: {
                return this.evaluateStringCondition(hsRequest.getPathInfo());
            }
            case 24: {
                return this.evaluateStringCondition(hsRequest.getPathTranslated());
            }
            case 25: {
                return this.evaluateStringCondition(hsRequest.getProtocol());
            }
            case 26: {
                return this.evaluateStringCondition(hsRequest.getQueryString());
            }
            case 27: {
                return this.evaluateStringCondition(hsRequest.getRemoteAddr());
            }
            case 28: {
                return this.evaluateStringCondition(hsRequest.getRemoteHost());
            }
            case 29: {
                return this.evaluateStringCondition(hsRequest.getRemoteUser());
            }
            case 30: {
                return this.evaluateStringCondition(hsRequest.getRequestedSessionId());
            }
            case 31: {
                return this.evaluateStringCondition(hsRequest.getRequestURI());
            }
            case 32: {
                StringBuffer requestUrlBuff = hsRequest.getRequestURL();
                String requestUrlStr = null;
                if (requestUrlBuff != null) {
                    requestUrlStr = requestUrlBuff.toString();
                }
                return this.evaluateStringCondition(requestUrlStr);
            }
            case 33: {
                Object sessionAttributeValue = null;
                if (hsRequest.getSession() != null && this.name != null) {
                    sessionAttributeValue = hsRequest.getSession().getAttribute(this.name);
                }
                return this.evaluateAttributeCondition(sessionAttributeValue);
            }
            case 34: {
                boolean sessionNew = false;
                HttpSession session = hsRequest.getSession();
                if (session != null) {
                    sessionNew = session.isNew();
                }
                return this.evaluateBoolCondition(sessionNew);
            }
            case 35: {
                return this.evaluateNumericCondition(hsRequest.getServerPort());
            }
            case 36: {
                return this.evaluateStringCondition(hsRequest.getServerName());
            }
            case 37: {
                return this.evaluateStringCondition(hsRequest.getScheme());
            }
            case 38: {
                log.debug("is user in role " + this.name + " op " + this.operator);
                return this.evaluateBoolCondition(hsRequest.isUserInRole(this.name));
            }
        }
        return this.evaluateHeaderCondition(hsRequest);
    }

    private ConditionMatch evaluateAttributeCondition(Object attribObject) {
        String attribValue = null;
        if (attribObject == null) {
            if (log.isDebugEnabled()) {
                log.debug(this.name + " doesn't exist");
            }
        } else {
            attribValue = attribObject.toString();
        }
        return this.evaluateStringCondition(attribValue);
    }

    private ConditionMatch evaluateCookieCondition(Cookie[] cookies, String name) {
        if (cookies == null) {
            return this.evaluateBoolCondition(false);
        }
        if (name == null) {
            return this.evaluateBoolCondition(false);
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (cookie == null || !name.equals(cookie.getName())) continue;
            return this.evaluateStringCondition(cookie.getValue());
        }
        return null;
    }

    private ConditionMatch evaluateStringCondition(String value) {
        if (this.pattern == null && value == null) {
            log.debug("value is empty and pattern is also, condition false");
            return this.evaluateBoolCondition(false);
        }
        if (this.pattern == null) {
            log.debug("value isn't empty but pattern is, assuming checking for existence, condition true");
            return this.evaluateBoolCondition(true);
        }
        if (value == null) {
            value = "";
        }
        if (log.isDebugEnabled()) {
            log.debug("evaluating \"" + value + "\" against " + this.strValue);
        }
        Matcher matcher = this.pattern.matcher(value);
        return this.evaluateBoolCondition(matcher, matcher.find());
    }

    private ConditionMatch evaluateBoolCondition(boolean outcome) {
        if (log.isTraceEnabled()) {
            log.trace("outcome " + outcome);
        }
        if (this.operator == 2) {
            log.debug("not equal operator in use");
            return !outcome ? new ConditionMatch() : null;
        }
        return outcome ? new ConditionMatch() : null;
    }

    private ConditionMatch evaluateBoolCondition(Matcher matcher, boolean outcome) {
        ConditionMatch conditionMatch = this.evaluateBoolCondition(outcome);
        if (conditionMatch != null) {
            conditionMatch.setMatcher(matcher);
        }
        return conditionMatch;
    }

    private ConditionMatch evaluateHeaderCondition(HttpServletRequest hsRequest) {
        String headerValue = null;
        if (this.name != null) {
            headerValue = hsRequest.getHeader(this.name);
        }
        return this.evaluateStringCondition(headerValue);
    }

    private ConditionMatch evaluateCalendarCondition(int calField) {
        return this.evaluateNumericCondition(Calendar.getInstance().get(calField));
    }

    private ConditionMatch evaluateNumericCondition(long compareWith) {
        if (log.isDebugEnabled()) {
            log.debug("evaluating with operator, is " + compareWith + " " + this.getOperator() + " " + this.numericValue);
        }
        switch (this.operator) {
            case 2: {
                return compareWith != this.numericValue ? new ConditionMatch() : null;
            }
            case 3: {
                return compareWith > this.numericValue ? new ConditionMatch() : null;
            }
            case 4: {
                return compareWith < this.numericValue ? new ConditionMatch() : null;
            }
            case 5: {
                return compareWith >= this.numericValue ? new ConditionMatch() : null;
            }
            case 6: {
                return compareWith <= this.numericValue ? new ConditionMatch() : null;
            }
        }
        return compareWith == this.numericValue ? new ConditionMatch() : null;
    }

    public boolean initialise() {
        this.initialised = true;
        if (this.error != null) {
            return false;
        }
        if (this.type == 0) {
            this.type = 1;
        }
        switch (this.type) {
            case 35: {
                this.initNumericValue();
                break;
            }
            case 4: {
                this.initNumericValue();
                break;
            }
            case 5: {
                this.initNumericValue();
                break;
            }
            case 6: {
                this.initNumericValue();
                break;
            }
            case 7: {
                this.initNumericValue();
                break;
            }
            case 8: {
                this.initNumericValue();
                break;
            }
            case 9: {
                this.initNumericValue();
                break;
            }
            case 10: {
                this.initNumericValue();
                break;
            }
            case 11: {
                this.initNumericValue();
                break;
            }
            case 12: {
                this.initNumericValue();
                break;
            }
            case 13: {
                this.initNumericValue();
                break;
            }
            case 17: {
                this.initNumericValue();
                break;
            }
            case 39: {
                this.initNumericValue();
                break;
            }
            case 38: {
                if (!StringUtils.isBlank(this.name)) break;
                this.name = this.strValue;
                break;
            }
            case 33: {
                if (StringUtils.isBlank(this.name)) {
                    this.setError("you must set a name for session attributes");
                }
                this.initStringValue();
                break;
            }
            case 14: {
                if (StringUtils.isBlank(this.name)) {
                    this.setError("you must set a name for attributes");
                }
                this.initStringValue();
                break;
            }
            case 1: {
                if (StringUtils.isBlank(this.name)) {
                    this.setError("you must set a name for a header");
                }
                this.initStringValue();
                break;
            }
            default: {
                this.initStringValue();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("loaded condition " + this.getType() + " " + this.name + " " + this.strValue);
        }
        this.valid = this.error == null;
        return this.valid;
    }

    private void initStringValue() {
        if (StringUtils.isBlank(this.strValue)) {
            log.debug("value is blank initing pattern to null");
            this.pattern = null;
            return;
        }
        try {
            this.pattern = this.caseSensitive ? Pattern.compile(this.strValue) : Pattern.compile(this.strValue, 2);
        }
        catch (PatternSyntaxException e) {
            this.setError("Problem compiling regular expression " + this.strValue + " (" + e.getMessage() + ")");
            return;
        }
        if (this.pattern == null) {
            this.setError("value \"" + this.strValue + "\" did not compile as a regular expression");
        }
    }

    private void initNumericValue() {
        if (this.numericValue == 0L) {
            this.numericValue = NumberUtils.stringToLong(StringUtils.trim(this.strValue));
            if (this.numericValue == 0L && !"0".equals(this.strValue)) {
                this.setError("Value " + this.strValue + " is not a valid number (tried to cast to java type long)");
            }
        }
    }

    protected void setError(String s) {
        super.setError(s);
        log.error("Condition " + this.id + " had error: " + s);
    }

    public String getOperator() {
        switch (this.operator) {
            case 2: {
                return "notequal";
            }
            case 3: {
                return "greater";
            }
            case 4: {
                return "less";
            }
            case 5: {
                return "greaterorequal";
            }
            case 6: {
                return "lessorequal";
            }
            case 1: {
                return "equal";
            }
        }
        return "";
    }

    public void setOperator(String operator) {
        if ("notequal".equals(operator)) {
            this.operator = (short)2;
        } else if ("greater".equals(operator)) {
            this.operator = (short)3;
        } else if ("less".equals(operator)) {
            this.operator = (short)4;
        } else if ("greaterorequal".equals(operator)) {
            this.operator = (short)5;
        } else if ("lessorequal".equals(operator)) {
            this.operator = (short)6;
        } else if ("equal".equals(operator) || StringUtils.isBlank(operator)) {
            this.operator = 1;
        } else {
            this.setError("Operator " + operator + " is not valid");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNext() {
        if (this.processNextOr) {
            return "or";
        }
        return "and";
    }

    public void setNext(String next) {
        if ("or".equals(next)) {
            this.processNextOr = true;
        } else if ("and".equals(next) || StringUtils.isBlank(next)) {
            this.processNextOr = false;
        } else {
            this.setError("Next " + next + " is not valid (can be 'and', 'or')");
        }
    }

    public String getValue() {
        return this.strValue;
    }

    public void setValue(String value) {
        this.strValue = value;
    }

    public boolean isProcessNextOr() {
        return this.processNextOr;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getDisplayName() {
        return "Condtition " + this.id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

