% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indel_context.R
\name{get_indel_context}
\alias{get_indel_context}
\title{Get indel contexts}
\usage{
get_indel_context(vcf_list, ref_genome)
}
\arguments{
\item{vcf_list}{GRanges or GRangesList object containing Indel mutations.
The mutations should be called similarly to HaplotypeCaller.}

\item{ref_genome}{BSGenome reference genome object}
}
\value{
A modified version of the input grl. In each gr two columns have been added.
"muttype" showing the main indel type and "muttype_sub" which shows the subtype.
The subtype is either the number of repeats or the microhomology length.
}
\description{
Get indel contexts
}
\details{
Determines the COSMIC context from a GRanges or GRangesList object containing Indel mutations.
It applies the get_indel_context_gr function to each gr in the input.
}
\examples{

## Get a GRangesList or GRanges object with only indels.
## See 'read_vcfs_as_granges' or 'get_mut_type' for more info on how to do this.
indel_grl <- readRDS(system.file("states/blood_grl_indel.rds",
  package = "MutationalPatterns"
))

## Load the corresponding reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Get the indel contexts
get_indel_context(indel_grl, ref_genome)
}
\seealso{
\code{\link{read_vcfs_as_granges}}, \code{\link{get_mut_type}}

Other Indels: 
\code{\link{count_indel_contexts}()},
\code{\link{plot_compare_indels}()},
\code{\link{plot_indel_contexts}()},
\code{\link{plot_main_indel_contexts}()}
}
\concept{Indels}
