// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUI.h"
#include "FontDim.pypp.hpp"

namespace bp = boost::python;

struct FontDim_wrapper : CEGUI::FontDim, bp::wrapper< CEGUI::FontDim > {

    FontDim_wrapper(CEGUI::FontDim const & arg )
    : CEGUI::FontDim( arg )
      , bp::wrapper< CEGUI::FontDim >(){
        // copy constructor
        
    }

    FontDim_wrapper( )
    : CEGUI::FontDim( )
      , bp::wrapper< CEGUI::FontDim >(){
        // null constructor
    
    }

    FontDim_wrapper(::CEGUI::String const & name, ::CEGUI::String const & font, ::CEGUI::String const & text, ::CEGUI::FontMetricType metric, float padding=0 )
    : CEGUI::FontDim( boost::ref(name), boost::ref(font), boost::ref(text), metric, padding )
      , bp::wrapper< CEGUI::FontDim >(){
        // constructor
    
    }

    virtual ::CEGUI::BaseDim * clone(  ) const  {
        if( bp::override func_clone = this->get_override( "clone" ) )
            return func_clone(  );
        else{
            return this->CEGUI::FontDim::clone(  );
        }
    }
    
    ::CEGUI::BaseDim * default_clone(  ) const  {
        return CEGUI::FontDim::clone( );
    }

    ::CEGUI::Font const * getFontObject( ::CEGUI::Window const & window ) const {
        return CEGUI::FontDim::getFontObject( boost::ref(window) );
    }

    virtual float getValue( ::CEGUI::Window const & wnd ) const  {
        if( bp::override func_getValue = this->get_override( "getValue" ) )
            return func_getValue( boost::ref(wnd) );
        else{
            return this->CEGUI::FontDim::getValue( boost::ref(wnd) );
        }
    }
    
    float default_getValue( ::CEGUI::Window const & wnd ) const  {
        return CEGUI::FontDim::getValue( boost::ref(wnd) );
    }

    virtual float getValue( ::CEGUI::Window const & wnd, ::CEGUI::Rectf const & container ) const  {
        if( bp::override func_getValue = this->get_override( "getValue" ) )
            return func_getValue( boost::ref(wnd), boost::ref(container) );
        else{
            return this->CEGUI::FontDim::getValue( boost::ref(wnd), boost::ref(container) );
        }
    }
    
    float default_getValue( ::CEGUI::Window const & wnd, ::CEGUI::Rectf const & container ) const  {
        return CEGUI::FontDim::getValue( boost::ref(wnd), boost::ref(container) );
    }

    virtual bool handleFontRenderSizeChange( ::CEGUI::Window & window, ::CEGUI::Font const * font ) const  {
        if( bp::override func_handleFontRenderSizeChange = this->get_override( "handleFontRenderSizeChange" ) )
            return func_handleFontRenderSizeChange( boost::ref(window), boost::python::ptr(font) );
        else{
            return this->CEGUI::FontDim::handleFontRenderSizeChange( boost::ref(window), boost::python::ptr(font) );
        }
    }
    
    bool default_handleFontRenderSizeChange( ::CEGUI::Window & window, ::CEGUI::Font const * font ) const  {
        return CEGUI::FontDim::handleFontRenderSizeChange( boost::ref(window), boost::python::ptr(font) );
    }

    virtual void writeXMLElementAttributes_impl( ::CEGUI::XMLSerializer & xml_stream ) const {
        if( bp::override func_writeXMLElementAttributes_impl = this->get_override( "writeXMLElementAttributes_impl" ) )
            func_writeXMLElementAttributes_impl( boost::ref(xml_stream) );
        else{
            this->CEGUI::FontDim::writeXMLElementAttributes_impl( boost::ref(xml_stream) );
        }
    }
    
    virtual void default_writeXMLElementAttributes_impl( ::CEGUI::XMLSerializer & xml_stream ) const {
        CEGUI::FontDim::writeXMLElementAttributes_impl( boost::ref(xml_stream) );
    }

    virtual void writeXMLElementName_impl( ::CEGUI::XMLSerializer & xml_stream ) const {
        if( bp::override func_writeXMLElementName_impl = this->get_override( "writeXMLElementName_impl" ) )
            func_writeXMLElementName_impl( boost::ref(xml_stream) );
        else{
            this->CEGUI::FontDim::writeXMLElementName_impl( boost::ref(xml_stream) );
        }
    }
    
    virtual void default_writeXMLElementName_impl( ::CEGUI::XMLSerializer & xml_stream ) const {
        CEGUI::FontDim::writeXMLElementName_impl( boost::ref(xml_stream) );
    }

    virtual void writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        if( bp::override func_writeXMLToStream = this->get_override( "writeXMLToStream" ) )
            func_writeXMLToStream( boost::ref(xml_stream) );
        else{
            this->CEGUI::BaseDim::writeXMLToStream( boost::ref(xml_stream) );
        }
    }
    
    void default_writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        CEGUI::BaseDim::writeXMLToStream( boost::ref(xml_stream) );
    }

};

void register_FontDim_class(){

    { //::CEGUI::FontDim
        typedef bp::class_< FontDim_wrapper, bp::bases< CEGUI::BaseDim > > FontDim_exposer_t;
        FontDim_exposer_t FontDim_exposer = FontDim_exposer_t( "FontDim", "*!\n\
        \n\
            Dimension type that represents some metric of a Font.\n\
            Implements BaseDim interface.\n\
        *\n", bp::init< >() );
        bp::scope FontDim_scope( FontDim_exposer );
        FontDim_exposer.def( bp::init< CEGUI::String const &, CEGUI::String const &, CEGUI::String const &, CEGUI::FontMetricType, bp::optional< float > >(( bp::arg("name"), bp::arg("font"), bp::arg("text"), bp::arg("metric"), bp::arg("padding")=0 ), "*!\n\
            \n\
                Constructor.\n\
        \n\
            @param name\n\
                String holding the name suffix of the window to be accessed to obtain\n\
                the font and  or text strings to be used when these items are not\n\
                explicitly given.\n\
        \n\
            @param font\n\
                String holding the name of the font to use for this dimension.  If the\n\
                string is empty, the font assigned to the window passed to getValue will\n\
                be used.\n\
        \n\
            @param text\n\
                String holding the text to be measured for horizontal extent. If this\n\
                is empty, the text from the window passed to getValue will be used.\n\
        \n\
            @param metric\n\
                One of the FontMetricType values indicating what we should represent.\n\
        \n\
            @param padding\n\
                constant pixel padding value to be added.\n\
            *\n") );
        { //::CEGUI::FontDim::clone
        
            typedef ::CEGUI::BaseDim * ( ::CEGUI::FontDim::*clone_function_type )(  ) const;
            typedef ::CEGUI::BaseDim * ( FontDim_wrapper::*default_clone_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "clone"
                , clone_function_type(&::CEGUI::FontDim::clone)
                , default_clone_function_type(&FontDim_wrapper::default_clone)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::FontDim::getFont
        
            typedef ::CEGUI::String const & ( ::CEGUI::FontDim::*getFont_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "getFont"
                , getFont_function_type( &::CEGUI::FontDim::getFont )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Get the current font of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::getFontObject
        
            typedef ::CEGUI::Font const * ( FontDim_wrapper::*getFontObject_function_type )( ::CEGUI::Window const & ) const;
            
            FontDim_exposer.def( 
                "getFontObject"
                , getFontObject_function_type( &FontDim_wrapper::getFontObject )
                , ( bp::arg("window") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::FontDim::getMetric
        
            typedef ::CEGUI::FontMetricType ( ::CEGUI::FontDim::*getMetric_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "getMetric"
                , getMetric_function_type( &::CEGUI::FontDim::getMetric )
                , "! Get the current metric of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::getName
        
            typedef ::CEGUI::String const & ( ::CEGUI::FontDim::*getName_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "getName"
                , getName_function_type( &::CEGUI::FontDim::getName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Get the current name of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::getPadding
        
            typedef float ( ::CEGUI::FontDim::*getPadding_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "getPadding"
                , getPadding_function_type( &::CEGUI::FontDim::getPadding )
                , "! Get the current padding of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::getText
        
            typedef ::CEGUI::String const & ( ::CEGUI::FontDim::*getText_function_type )(  ) const;
            
            FontDim_exposer.def( 
                "getText"
                , getText_function_type( &::CEGUI::FontDim::getText )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Get the current text of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::getValue
        
            typedef float ( ::CEGUI::FontDim::*getValue_function_type )( ::CEGUI::Window const & ) const;
            typedef float ( FontDim_wrapper::*default_getValue_function_type )( ::CEGUI::Window const & ) const;
            
            FontDim_exposer.def( 
                "getValue"
                , getValue_function_type(&::CEGUI::FontDim::getValue)
                , default_getValue_function_type(&FontDim_wrapper::default_getValue)
                , ( bp::arg("wnd") ) );
        
        }
        { //::CEGUI::FontDim::getValue
        
            typedef float ( ::CEGUI::FontDim::*getValue_function_type )( ::CEGUI::Window const &,::CEGUI::Rectf const & ) const;
            typedef float ( FontDim_wrapper::*default_getValue_function_type )( ::CEGUI::Window const &,::CEGUI::Rectf const & ) const;
            
            FontDim_exposer.def( 
                "getValue"
                , getValue_function_type(&::CEGUI::FontDim::getValue)
                , default_getValue_function_type(&FontDim_wrapper::default_getValue)
                , ( bp::arg("wnd"), bp::arg("container") ) );
        
        }
        { //::CEGUI::FontDim::handleFontRenderSizeChange
        
            typedef bool ( ::CEGUI::FontDim::*handleFontRenderSizeChange_function_type )( ::CEGUI::Window &,::CEGUI::Font const * ) const;
            typedef bool ( FontDim_wrapper::*default_handleFontRenderSizeChange_function_type )( ::CEGUI::Window &,::CEGUI::Font const * ) const;
            
            FontDim_exposer.def( 
                "handleFontRenderSizeChange"
                , handleFontRenderSizeChange_function_type(&::CEGUI::FontDim::handleFontRenderSizeChange)
                , default_handleFontRenderSizeChange_function_type(&FontDim_wrapper::default_handleFontRenderSizeChange)
                , ( bp::arg("window"), bp::arg("font") ) );
        
        }
        { //::CEGUI::FontDim::setFont
        
            typedef void ( ::CEGUI::FontDim::*setFont_function_type )( ::CEGUI::String const & ) ;
            
            FontDim_exposer.def( 
                "setFont"
                , setFont_function_type( &::CEGUI::FontDim::setFont )
                , ( bp::arg("font") )
                , "! Set the current font of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::setMetric
        
            typedef void ( ::CEGUI::FontDim::*setMetric_function_type )( ::CEGUI::FontMetricType ) ;
            
            FontDim_exposer.def( 
                "setMetric"
                , setMetric_function_type( &::CEGUI::FontDim::setMetric )
                , ( bp::arg("metric") )
                , "! Set the current metric of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::setName
        
            typedef void ( ::CEGUI::FontDim::*setName_function_type )( ::CEGUI::String const & ) ;
            
            FontDim_exposer.def( 
                "setName"
                , setName_function_type( &::CEGUI::FontDim::setName )
                , ( bp::arg("name") )
                , "! Set the current name of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::setPadding
        
            typedef void ( ::CEGUI::FontDim::*setPadding_function_type )( float ) ;
            
            FontDim_exposer.def( 
                "setPadding"
                , setPadding_function_type( &::CEGUI::FontDim::setPadding )
                , ( bp::arg("padding") )
                , "! Set the current padding of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::setText
        
            typedef void ( ::CEGUI::FontDim::*setText_function_type )( ::CEGUI::String const & ) ;
            
            FontDim_exposer.def( 
                "setText"
                , setText_function_type( &::CEGUI::FontDim::setText )
                , ( bp::arg("text") )
                , "! Set the current text of the FontDim.\n" );
        
        }
        { //::CEGUI::FontDim::writeXMLElementAttributes_impl
        
            typedef void ( FontDim_wrapper::*writeXMLElementAttributes_impl_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            FontDim_exposer.def( 
                "writeXMLElementAttributes_impl"
                , writeXMLElementAttributes_impl_function_type( &FontDim_wrapper::default_writeXMLElementAttributes_impl )
                , ( bp::arg("xml_stream") )
                , "Implementation of the base class interface\n" );
        
        }
        { //::CEGUI::FontDim::writeXMLElementName_impl
        
            typedef void ( FontDim_wrapper::*writeXMLElementName_impl_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            FontDim_exposer.def( 
                "writeXMLElementName_impl"
                , writeXMLElementName_impl_function_type( &FontDim_wrapper::default_writeXMLElementName_impl )
                , ( bp::arg("xml_stream") )
                , "Implementation of the base class interface\n" );
        
        }
        { //::CEGUI::BaseDim::writeXMLToStream
        
            typedef void ( ::CEGUI::BaseDim::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            typedef void ( FontDim_wrapper::*default_writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            FontDim_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type(&::CEGUI::BaseDim::writeXMLToStream)
                , default_writeXMLToStream_function_type(&FontDim_wrapper::default_writeXMLToStream)
                , ( bp::arg("xml_stream") ) );
        
        }
    }

}
