
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramFlagsAttributes.h
    \\brief Definition of MetgramFlags Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MetgramFlagsAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MetgramFlagsAttributes::MetgramFlagsAttributes():
	frequency_(ParameterManager::getInt("metgram_flag_frequency")),
	method_(ParameterManager::getString("metgram_flag_method")),
	component1_(ParameterManager::getString("metgram_flag_component1")),
	component2_(ParameterManager::getString("metgram_flag_component2")),
	length_(ParameterManager::getDouble("metgram_flag_length"))
	,
	colour_(MagTranslator<string, Colour>().magics("metgram_flag_colour"))
	 
{
} 


MetgramFlagsAttributes::~MetgramFlagsAttributes()
{
	
}

    
void MetgramFlagsAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "metgram";
	
	setAttribute(prefix, "metgram_flag_frequency", frequency_, params);
	setAttribute(prefix, "metgram_flag_method", method_, params);
	setAttribute(prefix, "metgram_flag_component1", component1_, params);
	setAttribute(prefix, "metgram_flag_component2", component2_, params);
	setAttribute(prefix, "metgram_flag_length", length_, params);
	
	setMember(prefix, "metgram_flag_colour", colour_, params);
	
}

void MetgramFlagsAttributes::copy(const MetgramFlagsAttributes& other)
{
	frequency_ = other.frequency_;
	method_ = other.method_;
	component1_ = other.component1_;
	component2_ = other.component2_;
	length_ = other.length_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	
} 


bool MetgramFlagsAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "metflags")  )
		return true;
	
	return false;
}

void MetgramFlagsAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metflags")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MetgramFlagsAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " frequency = " <<  frequency_;
	out << " method = " <<  method_;
	out << " component1 = " <<  component1_;
	out << " component2 = " <<  component2_;
	out << " length = " <<  length_;
	out << " colour = " <<  *colour_;
	
	out << "]" << "\n";
}

void MetgramFlagsAttributes::toxml(ostream& out)  const
{
	out <<  "\"metflags\""; 
	out << ", \"metgram_flag_frequency\":";
	niceprint(out,frequency_);
	out << ", \"metgram_flag_method\":";
	niceprint(out,method_);
	out << ", \"metgram_flag_component1\":";
	niceprint(out,component1_);
	out << ", \"metgram_flag_component2\":";
	niceprint(out,component2_);
	out << ", \"metgram_flag_length\":";
	niceprint(out,length_);
	out << ", \"metgram_flag_colour\":";
	niceprint(out, *colour_);
	
}

static MagicsParameter<int> metgram_flag_frequency("metgram_flag_frequency", 1, "");
static MagicsParameter<string> metgram_flag_method("metgram_flag_method", "SD", "");
static MagicsParameter<string> metgram_flag_component1("metgram_flag_component1", "curve1", "");
static MagicsParameter<string> metgram_flag_component2("metgram_flag_component2", "curve2", "");
static MagicsParameter<double> metgram_flag_length("metgram_flag_length", 0.5, "");
static MagicsParameter<string> metgram_flag_colour("metgram_flag_colour", "red", ""); 
