/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.MockServletContext;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.Run;
import org.tuckey.web.filters.urlrewrite.TestRunObj;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class RunTest
extends TestCase {
    MockResponse response;
    MockRequest request;
    MockServletContext servletContext;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$TestRunObj;

    public void setUp() {
        Log.setLevel("DEBUG");
        this.response = new MockResponse();
        this.request = new MockRequest();
        this.servletContext = new MockServletContext();
        TestRunObj.resetTestFlags();
    }

    public void testRun01() throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.initialise(this.servletContext);
        RunTest.assertTrue((String)("Should be a initialised " + run.getError()), (boolean)run.isValid());
        RunTest.assertTrue((String)"Should be created now", (TestRunObj.getCreatedCount() == 1 ? 1 : 0) != 0);
        RunTest.assertTrue((String)"Should be inited now", (boolean)TestRunObj.isInitCalled());
        run.execute(this.request, this.response);
        RunTest.assertTrue((String)"Should be invoked", (boolean)TestRunObj.isRunCalled());
        RunTest.assertTrue((String)"Should not have been created again", (TestRunObj.getCreatedCount() == 1 ? 1 : 0) != 0);
        RunTest.assertFalse((String)"Should not be destroyed", (boolean)TestRunObj.isDestroyCalled());
        run.destroy();
        RunTest.assertTrue((String)"Should be destroyed", (boolean)TestRunObj.isDestroyCalled());
    }

    public void testRunBadObj() throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException, ServletException {
        Run run = new Run();
        run.setClassStr("this.is.an.not.found.Class");
        run.initialise(this.servletContext);
        RunTest.assertFalse((String)("Should not be initialised " + run.getError()), (boolean)run.isValid());
        run.execute(this.request, this.response);
    }

    public void testRunBadMethod() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr("badMethod");
        run.initialise(this.servletContext);
        RunTest.assertFalse((String)("Should not be initialised " + run.getError()), (boolean)run.isValid());
        run.execute(this.request, this.response);
    }

    public void testRunThatReturns() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr("runThatReturns");
        run.initialise(this.servletContext);
        RunTest.assertTrue((String)("Should be initialised " + run.getError()), (boolean)run.isValid());
        run.execute(this.request, this.response);
    }

    public void testRunCustomMethod() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr("nonDefaultRun");
        run.initialise(this.servletContext);
        RunTest.assertTrue((String)("Should be initialised " + run.getError()), (boolean)run.isValid());
        run.execute(this.request, this.response);
        RunTest.assertTrue((String)"Should be invoked", (boolean)TestRunObj.isNonDefaultRunCalled());
    }

    private Throwable doExceptionRun(String methodName) {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr(methodName);
        run.initialise(this.servletContext);
        RunTest.assertTrue((String)("Should be initialised, but: " + run.getError()), (boolean)run.isValid());
        Throwable throwableViaRun = null;
        System.out.println("this...");
        try {
            run.execute(this.request, this.response);
        }
        catch (Throwable t) {
            throwableViaRun = t;
            t.printStackTrace(System.out);
        }
        return throwableViaRun;
    }

    public void testRunExceptionMethod() {
        Throwable throwableViaRun = this.doExceptionRun("runNullPointerException");
        Throwable throwableRaw = null;
        System.out.println("should look the same as this...");
        try {
            new TestRunObj().runNullPointerException(null, null);
        }
        catch (Throwable t) {
            throwableRaw = t;
            t.printStackTrace(System.out);
        }
        RunTest.assertEquals((String)throwableRaw.toString(), (String)throwableViaRun.toString());
    }

    public void testRunServletExceptionMethod() {
        Throwable throwableViaRun = this.doExceptionRun("runServletException");
        Throwable throwableRaw = null;
        System.out.println("should look the same as this...");
        TestRunObj testRunObj = new TestRunObj();
        try {
            testRunObj.runServletException(null, null);
        }
        catch (Throwable t) {
            throwableRaw = t;
            t.printStackTrace(System.out);
        }
        RunTest.assertEquals((String)throwableRaw.toString(), (String)throwableViaRun.toString());
    }

    public void testRunCustomExceptionMethod() {
        Throwable throwableViaRun = this.doExceptionRun("runCustomException");
        Throwable throwableRaw = null;
        System.out.println("should look the same as this...");
        TestRunObj testRunObj = new TestRunObj();
        try {
            testRunObj.runCustomException(null, null);
        }
        catch (Throwable t) {
            throwableRaw = t;
            t.printStackTrace(System.out);
        }
        RunTest.assertEquals((String)throwableRaw.toString(), (String)throwableViaRun.getCause().toString());
    }

    public void testRunIOExceptionMethod() {
        Throwable throwableViaRun = this.doExceptionRun("runIOException");
        Throwable throwableRaw = null;
        System.out.println("should look the same as this...");
        TestRunObj testRunObj = new TestRunObj();
        try {
            testRunObj.runIOException(null, null);
        }
        catch (Throwable t) {
            throwableRaw = t;
            t.printStackTrace(System.out);
        }
        RunTest.assertEquals((String)throwableRaw.toString(), (String)throwableViaRun.toString());
    }

    public void testRunRuntimeExceptionMethod() {
        Throwable throwableViaRun = this.doExceptionRun("runRuntiumeException");
        Throwable throwableRaw = null;
        System.out.println("should look the same as this...");
        TestRunObj testRunObj = new TestRunObj();
        try {
            testRunObj.runRuntiumeException(null, null);
        }
        catch (Throwable t) {
            throwableRaw = t;
            t.printStackTrace(System.out);
        }
        RunTest.assertEquals((String)throwableRaw.toString(), (String)throwableViaRun.toString());
    }

    public void testRunPrivateMethod() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr("privateRun");
        run.initialise(this.servletContext);
        RunTest.assertFalse((String)("Should not be initialised " + run.getError()), (boolean)run.isValid());
        run.execute(this.request, this.response);
    }

    public void testRunNewEach() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setNewEachTime(true);
        run.initialise(this.servletContext);
        RunTest.assertTrue((String)"Should not have been created yet", (TestRunObj.getCreatedCount() == 0 ? 1 : 0) != 0);
        run.execute(this.request, this.response);
        RunTest.assertTrue((String)"Should be created now", (TestRunObj.getCreatedCount() == 1 ? 1 : 0) != 0);
        run.execute(this.request, this.response);
        RunTest.assertTrue((String)"Should be created twice", (TestRunObj.getCreatedCount() == 2 ? 1 : 0) != 0);
        RunTest.assertTrue((String)"Should be destroyed", (boolean)TestRunObj.isDestroyCalled());
    }

    public void testInitParams() {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.addInitParam("horse", "golden");
        run.addInitParam("debs", "nightout");
        run.initialise(this.servletContext);
        RunTest.assertEquals((String)"golden", (String)TestRunObj.getTestServletConfig().getInitParameter("horse"));
        RunTest.assertEquals((String)"nightout", (String)TestRunObj.getTestServletConfig().getInitParameter("debs"));
    }

    public void testRuleNoToWithRun() throws IOException, ServletException {
        Run run = new Run();
        run.setClassStr((class$org$tuckey$web$filters$urlrewrite$TestRunObj == null ? (class$org$tuckey$web$filters$urlrewrite$TestRunObj = RunTest.class$("org.tuckey.web.filters.urlrewrite.TestRunObj")) : class$org$tuckey$web$filters$urlrewrite$TestRunObj).getName());
        run.setMethodStr("run");
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.addRun(run);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RunTest.assertNull((Object)rewrittenUrl);
        RunTest.assertTrue((boolean)TestRunObj.isRunCalled());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

