'\"
'\" Generated from file 'ncgi\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "ncgi" n 1\&.4\&.4 tcllib "CGI Support"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
ncgi \- Procedures to manipulate CGI values\&.
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBncgi  ?1\&.4\&.4?\fR
.sp
\fB::ncgi::cookie\fR \fIcookie\fR
.sp
\fB::ncgi::decode\fR \fIstr\fR
.sp
\fB::ncgi::empty\fR \fIname\fR
.sp
\fB::ncgi::exists\fR \fIname\fR
.sp
\fB::ncgi::encode\fR \fIstring\fR
.sp
\fB::ncgi::header\fR ?\fItype\fR? \fIargs\fR
.sp
\fB::ncgi::import\fR \fIcginame\fR ?\fItclname\fR?
.sp
\fB::ncgi::importAll\fR \fIargs\fR
.sp
\fB::ncgi::importFile\fR \fIcmd\fR \fIcginame\fR ?\fIfilename\fR?
.sp
\fB::ncgi::input\fR ?\fIfakeinput\fR? ?\fIfakecookie\fR?
.sp
\fB::ncgi::multipart\fR \fItype query\fR
.sp
\fB::ncgi::nvlist\fR
.sp
\fB::ncgi::names\fR
.sp
\fB::ncgi::parse\fR
.sp
\fB::ncgi::parseMimeValue\fR \fIvalue\fR
.sp
\fB::ncgi::query\fR
.sp
\fB::ncgi::redirect\fR \fIurl\fR
.sp
\fB::ncgi::reset\fR \fIquery type\fR
.sp
\fB::ncgi::setCookie\fR \fIargs\fR
.sp
\fB::ncgi::setDefaultValue\fR \fIkey defvalue\fR
.sp
\fB::ncgi::setDefaultValueList\fR \fIkey defvaluelist\fR
.sp
\fB::ncgi::setValue\fR \fIkey value\fR
.sp
\fB::ncgi::setValueList\fR \fIkey valuelist\fR
.sp
\fB::ncgi::type\fR
.sp
\fB::ncgi::urlStub\fR ?\fIurl\fR?
.sp
\fB::ncgi::value\fR \fIkey\fR ?\fIdefault\fR?
.sp
\fB::ncgi::valueList\fR \fIkey\fR ?\fIdefault\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The \fBncgi\fR package provides commands that manipulate CGI
values\&.  These are values that come from Web forms and are processed
either by CGI scripts or web pages with embedded Tcl code\&.  Use the
\fBncgi\fR package to query these values, set and get cookies, and
encode and decode www-url-encoded values\&.
.PP
In the simplest case, a CGI script first calls \fB::ncgi::parse\fR and
then calls \fB::ncgi::value\fR to get different form values\&.  If a CGI
value is repeated, you should use \fB::ncgi::valueList\fR to get back
the complete list of values\&.
.PP
An alternative to \fB::ncgi::parse\fR is \fB::ncgi::input\fR, which
has semantics similar to Don Libes' \fBcgi_input\fR procedure\&.
\fB::ncgi::input\fR restricts repeated CGI values to have names that
end with "List"\&.  In this case, \fB::ncgi::value\fR will return the
complete list of values, and \fB::ncgi::input\fR will raise errors if
it find repeated form elements without the right name\&.
.PP
The \fB::ncgi::reset\fR procedure can be used in test suites and Web
servers to initialize the source of the CGI values\&.  Otherwise the
values are read in from the CGI environment\&.
.PP
The complete set of procedures is described below\&.
.TP
\fB::ncgi::cookie\fR \fIcookie\fR
Return a list of values for \fIcookie\fR, if any\&.  It is possible that
more than one cookie with the same name can be present, so this
procedure returns a list\&.
.TP
\fB::ncgi::decode\fR \fIstr\fR
Decode strings in www-url-encoding, which represents special
characters with a %xx sequence, where xx is the character code in hex\&.
.TP
\fB::ncgi::empty\fR \fIname\fR
Returns 1 if the CGI variable \fIname\fR is not present or has the
empty string as its value\&.
.TP
\fB::ncgi::exists\fR \fIname\fR
The return value is a boolean\&. It returns \fB0\fR if the CGI
variable \fIname\fR is not present, and \fB1\fR otherwise\&.
.TP
\fB::ncgi::encode\fR \fIstring\fR
Encode \fIstring\fR into www-url-encoded format\&.
.TP
\fB::ncgi::header\fR ?\fItype\fR? \fIargs\fR
Output the CGI header to standard output\&.  This emits a Content-Type:
header and additional headers based on \fIargs\fR, which is a list of
header names and header values\&. The \fItype\fR defaults to
"text/html"\&.
.TP
\fB::ncgi::import\fR \fIcginame\fR ?\fItclname\fR?
This creates a variable in the current scope with the value of the CGI
variable \fIcginame\fR\&.  The name of the variable is \fItclname\fR, or
\fIcginame\fR if \fItclname\fR is empty (default)\&.
.TP
\fB::ncgi::importAll\fR \fIargs\fR
This imports several CGI variables as Tcl variables\&.  If \fIargs\fR is
empty, then every CGI value is imported\&.  Otherwise each CGI variable
listed in \fIargs\fR is imported\&.
.TP
\fB::ncgi::importFile\fR \fIcmd\fR \fIcginame\fR ?\fIfilename\fR?
This provides information about an uploaded file from a form input
field of type \fBfile\fR with name \fIcginame\fR\&.  \fIcmd\fR can be
one of \fB-server\fR \fB-client\fR, \fB-type\fR or
\fB-data\fR\&.
.RS
.TP
\fB-client\fR \fIcginame\fR
returns the filename as sent by the client\&.
.TP
\fB-type\fR \fIcginame\fR
returns the mime type of the uploaded file\&.
.TP
\fB-data\fR \fIcginame\fR
returns the contents of the file\&.
.TP
\fB-server\fR \fIcginame\fR \fIfilename\fR
writes the file contents to a local temporary file (or \fIfilename\fR
if supplied) and returns the name of the file\&. The caller is
responsible for deleting this file after use\&.
.RE
.TP
\fB::ncgi::input\fR ?\fIfakeinput\fR? ?\fIfakecookie\fR?
This reads and decodes the CGI values from the environment\&.  It
restricts repeated form values to have a trailing "List" in their
name\&.  The CGI values are obtained later with the \fB::ncgi::value\fR
procedure\&.
.TP
\fB::ncgi::multipart\fR \fItype query\fR
This procedure parses a multipart/form-data \fIquery\fR\&.  This is used
by \fB::ncgi::nvlist\fR and not normally called directly\&.  It returns
an alternating list of names and structured values\&.  Each structure
value is in turn a list of two elements\&.  The first element is
meta-data from the multipart/form-data structure\&.  The second element
is the form value\&.  If you use \fB::ncgi::value\fR you just get the
form value\&.  If you use \fB::ncgi::valueList\fR you get the structured
value with meta data and the value\&.
.sp
The \fItype\fR is the whole Content-Type, including the parameters
like \fIboundary\fR\&.  This returns a list of names and values that
describe the multipart data\&.  The values are a nested list structure
that has some descriptive information first, and the actual form value
second\&.  The descriptive information is list of header names and
values that describe the content\&.
.TP
\fB::ncgi::nvlist\fR
This returns all the query data as a name, value list\&.  In the case of
multipart/form-data, the values are structured as described in
\fB::ncgi::multipart\fR\&.
.TP
\fB::ncgi::names\fR
This returns all names found in the query data, as a list\&.
\fB::ncgi::multipart\fR\&.
.TP
\fB::ncgi::parse\fR
This reads and decodes the CGI values from the environment\&.  The CGI
values are obtained later with the \fB::ncgi::value\fR procedure\&.  IF
a CGI value is repeated, then you should use \fB::ncgi::valueList\fR
to get the complete list of values\&.
.TP
\fB::ncgi::parseMimeValue\fR \fIvalue\fR
This decodes the Content-Type and other MIME headers that have the
form of "primary value; param=val; p2=v2" It returns a list, where the
first element is the primary value, and the second element is a list
of parameter names and values\&.
.TP
\fB::ncgi::query\fR
This returns the raw query data\&.
.TP
\fB::ncgi::redirect\fR \fIurl\fR
Generate a response that causes a 302 redirect by the Web server\&.  The
\fIurl\fR is the new URL that is the target of the redirect\&.  The URL
will be qualified with the current server and current directory, if
necessary, to convert it into a full URL\&.
.TP
\fB::ncgi::reset\fR \fIquery type\fR
Set the query data and Content-Type for the current CGI session\&.  This
is used by the test suite and by Web servers to initialize the ncgi
module so it does not try to read standard input or use environment
variables to get its data\&.  If neither \fIquery\fR or \fItype\fR are
specified, then the \fBncgi\fR module will look in the standard
CGI environment for its data\&.
.TP
\fB::ncgi::setCookie\fR \fIargs\fR
Set a cookie value that will be returned as part of the reply\&.  This
must be done before \fB::ncgi::header\fR or \fB::ncgi::redirect\fR is
called in order for the cookie to be returned properly\&.  The
\fIargs\fR are a set of flags and values:
.RS
.TP
\fB-name\fR \fIname\fR
.TP
\fB-value\fR \fIvalue\fR
.TP
\fB-expires\fR \fIdate\fR
.TP
\fB-path\fR \fIpath restriction\fR
.TP
\fB-domain\fR \fIdomain restriction\fR
.RE
.TP
\fB::ncgi::setDefaultValue\fR \fIkey defvalue\fR
Set a CGI value if it does not already exists\&.  This affects future
calls to \fB::ncgi::value\fR (but not future calls to
\fB::ncgi::nvlist\fR)\&.  If the CGI value already is present, then this
procedure has no side effects\&.
.TP
\fB::ncgi::setDefaultValueList\fR \fIkey defvaluelist\fR
Like \fB::ncgi::setDefaultValue\fR except that the value already has
list structure to represent multiple checkboxes or a multi-selection\&.
.TP
\fB::ncgi::setValue\fR \fIkey value\fR
Set a CGI value, overriding whatever was present in the CGI
environment already\&.  This affects future calls to \fB::ncgi::value\fR
(but not future calls to \fB::ncgi::nvlist\fR)\&.
.TP
\fB::ncgi::setValueList\fR \fIkey valuelist\fR
Like \fB::ncgi::setValue\fR except that the value already has list
structure to represent multiple checkboxes or a multi-selection\&.
.TP
\fB::ncgi::type\fR
Returns the Content-Type of the current CGI values\&.
.TP
\fB::ncgi::urlStub\fR ?\fIurl\fR?
Returns the current URL, but without the protocol, server, and port\&.
If \fIurl\fR is specified, then it defines the URL for the current
session\&.  That value will be returned by future calls to
\fB::ncgi::urlStub\fR
.TP
\fB::ncgi::value\fR \fIkey\fR ?\fIdefault\fR?
Return the CGI value identified by \fIkey\fR\&.  If the CGI value is not
present, then the \fIdefault\fR value is returned instead\&. This value
defaults to the empty string\&.
.sp
If the form value \fIkey\fR is repeated, then there are two cases: if
\fB::ncgi::parse\fR was called, then \fB::ncgi::value\fR only returns
the first value associated with \fIkey\fR\&.  If \fB::ncgi::input\fR was
called, then \fB::ncgi::value\fR returns a Tcl list value and
\fIkey\fR must end in "List" (e\&.g\&., "skuList")\&.  In the case of
multipart/form-data, this procedure just returns the value of the form
element\&.  If you want the meta-data associated with each form value,
then use \fB::ncgi::valueList\fR\&.
.TP
\fB::ncgi::valueList\fR \fIkey\fR ?\fIdefault\fR?
Like \fB::ncgi::value\fR, but this always returns a list of values
(even if there is only one value)\&.  In the case of
multipart/form-data, this procedure returns a list of two elements\&.
The first element is meta-data in the form of a parameter, value list\&.
The second element is the form value\&.
.PP
.SH EXAMPLES
Uploading a file
.CS


HTML:
<html>
<form action="/cgi-bin/upload\&.cgi" method="POST" enctype="multipart/form-data">
Path: <input type="file" name="filedata"><br>
Name: <input type="text" name="filedesc"><br>
<input type="submit">
</form>
</html>

TCL: upload\&.cgi
#!/usr/local/bin/tclsh

::ncgi::parse
set filedata [::ncgi::value filedata]
set filedesc [::ncgi::value filedesc]

puts "<html> File uploaded at <a href=\\"/images/$filedesc\\">$filedesc</a> </html>"

set filename /www/images/$filedesc

set fh [open $filename w]
puts -nonewline $fh $filedata
close $fh

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIncgi\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
html
.SH KEYWORDS
CGI, cookie, form, html
.SH CATEGORY
CGI programming
