'\"
'\" Generated from file 'bignum\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Salvatore Sanfilippo <antirez at invece dot org>
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus at users dot sourceforge dot net>
'\"
.TH "math::bignum" n 3\&.1 tcllib "Tcl Math Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::bignum \- Arbitrary precision integer numbers
.SH SYNOPSIS
package require \fBTcl  ?8\&.4?\fR
.sp
package require \fBmath::bignum  ?3\&.1?\fR
.sp
\fB::math::bignum::fromstr\fR \fIstring\fR ?\fIradix\fR?
.sp
\fB::math::bignum::tostr\fR \fIbignum\fR ?\fIradix\fR?
.sp
\fB::math::bignum::sign\fR \fIbignum\fR
.sp
\fB::math::bignum::abs\fR \fIbignum\fR
.sp
\fB::math::bignum::cmp\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::iszero\fR \fIbignum\fR
.sp
\fB::math::bignum::lt\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::le\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::gt\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::ge\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::eq\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::ne\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::isodd\fR \fIbignum\fR
.sp
\fB::math::bignum::iseven\fR \fIbignum\fR
.sp
\fB::math::bignum::add\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::sub\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::mul\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::divqr\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::div\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::rem\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::mod\fR \fIn\fR \fIm\fR
.sp
\fB::math::bignum::pow\fR \fIbase\fR \fIexp\fR
.sp
\fB::math::bignum::powm\fR \fIbase\fR \fIexp\fR \fIm\fR
.sp
\fB::math::bignum::sqrt\fR \fIbignum\fR
.sp
\fB::math::bignum::rand\fR \fIbits\fR
.sp
\fB::math::bignum::lshift\fR \fIbignum\fR \fIbits\fR
.sp
\fB::math::bignum::rshift\fR \fIbignum\fR \fIbits\fR
.sp
\fB::math::bignum::bitand\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::bitor\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::bitxor\fR \fIa\fR \fIb\fR
.sp
\fB::math::bignum::setbit\fR \fIbignumVar\fR \fIbit\fR
.sp
\fB::math::bignum::clearbit\fR \fIbignumVar\fR \fIbit\fR
.sp
\fB::math::bignum::testbit\fR \fIbignum\fR \fIbit\fR
.sp
\fB::math::bignum::bits\fR \fIbignum\fR
.sp
.BE
.SH DESCRIPTION
.PP
The bignum package provides arbitrary precision integer math
(also known as "big numbers") capabilities to the Tcl language\&.
Big numbers are internally represented at Tcl lists: this
package provides a set of procedures operating against
the internal representation in order to:
.IP \(bu
perform math operations
.IP \(bu
convert bignums from the internal representation to a string in
the desired radix and vice versa\&.
.PP
But the two constants "0" and "1" are automatically converted to
the internal representation, in order to easily compare a number to zero,
or increment a big number\&.
.PP
The bignum interface is opaque, so
operations on bignums that are not returned by procedures
in this package (but created by hand) may lead to unspecified behaviours\&.
It's safe to treat bignums as pure values, so there is no need
to free a bignum, or to duplicate it via a special operation\&.
.SH EXAMPLES
This section shows some simple example\&. This library being just
a way to perform math operations, examples may be the simplest way
to learn how to work with it\&. Consult the API section of
this man page for information about individual procedures\&.
.PP
.CS


    package require math::bignum

    # Multiplication of two bignums
    set a [::math::bignum::fromstr 88888881111111]
    set b [::math::bignum::fromstr 22222220000000]
    set c [::math::bignum::mul $a $b]
    puts [::math::bignum::tostr $c] ; # => will output 1975308271604953086420000000
    set c [::math::bignum::sqrt $c]
    puts [::math::bignum::tostr $c] ; # => will output 44444440277777

    # From/To string conversion in different radix
    set a [::math::bignum::fromstr 1100010101010111001001111010111 2]
    puts [::math::bignum::tostr $a 16] ; # => will output 62ab93d7

    # Factorial example
    proc fact n {
        # fromstr is not needed for 0 and 1
        set z 1
        for {set i 2} {$i <= $n} {incr i} {
            set z [::math::bignum::mul $z [::math::bignum::fromstr $i]]
        }
        return $z
    }

    puts [::math::bignum::tostr [fact 100]]

.CE
.SH API
.TP
\fB::math::bignum::fromstr\fR \fIstring\fR ?\fIradix\fR?
Convert \fIstring\fR into a bignum\&. If \fIradix\fR is omitted or zero,
the string is interpreted in hex if prefixed with
\fI0x\fR, in octal if prefixed with \fIox\fR,
in binary if it's pefixed with \fIbx\fR, as a number in
radix 10 otherwise\&. If instead the \fIradix\fR argument
is specified in the range 2-36, the \fIstring\fR is interpreted
in the given radix\&. Please note that this conversion is
not needed for two constants : \fI0\fR and \fI1\fR\&. (see the example)
.TP
\fB::math::bignum::tostr\fR \fIbignum\fR ?\fIradix\fR?
Convert \fIbignum\fR into a string representing the number
in the specified radix\&. If \fIradix\fR is omitted, the
default is 10\&.
.TP
\fB::math::bignum::sign\fR \fIbignum\fR
Return the sign of the bignum\&.
The procedure returns 0 if the number is positive, 1 if it's negative\&.
.TP
\fB::math::bignum::abs\fR \fIbignum\fR
Return the absolute value of the bignum\&.
.TP
\fB::math::bignum::cmp\fR \fIa\fR \fIb\fR
Compare the two bignums a and b, returning \fI0\fR if \fIa == b\fR,
\fI1\fR if \fIa > b\fR, and \fI-1\fR if \fIa < b\fR\&.
.TP
\fB::math::bignum::iszero\fR \fIbignum\fR
Return true if \fIbignum\fR value is zero, otherwise false is returned\&.
.TP
\fB::math::bignum::lt\fR \fIa\fR \fIb\fR
Return true if \fIa < b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::le\fR \fIa\fR \fIb\fR
Return true if \fIa <= b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::gt\fR \fIa\fR \fIb\fR
Return true if \fIa > b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::ge\fR \fIa\fR \fIb\fR
Return true if \fIa >= b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::eq\fR \fIa\fR \fIb\fR
Return true if \fIa == b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::ne\fR \fIa\fR \fIb\fR
Return true if \fIa != b\fR, otherwise false is returned\&.
.TP
\fB::math::bignum::isodd\fR \fIbignum\fR
Return true if \fIbignum\fR is odd\&.
.TP
\fB::math::bignum::iseven\fR \fIbignum\fR
Return true if \fIbignum\fR is even\&.
.TP
\fB::math::bignum::add\fR \fIa\fR \fIb\fR
Return the sum of the two bignums \fIa\fR and \fIb\fR\&.
.TP
\fB::math::bignum::sub\fR \fIa\fR \fIb\fR
Return the difference of the two bignums \fIa\fR and \fIb\fR\&.
.TP
\fB::math::bignum::mul\fR \fIa\fR \fIb\fR
Return the product of the two bignums \fIa\fR and \fIb\fR\&.
The implementation uses Karatsuba multiplication if both
the numbers are bigger than a given threshold, otherwise
the direct algorith is used\&.
.TP
\fB::math::bignum::divqr\fR \fIa\fR \fIb\fR
Return a two-elements list containing as first element
the quotient of the division between the two bignums
\fIa\fR and \fIb\fR, and the remainder of the division as second element\&.
.TP
\fB::math::bignum::div\fR \fIa\fR \fIb\fR
Return the quotient of the division between the two
bignums \fIa\fR and \fIb\fR\&.
.TP
\fB::math::bignum::rem\fR \fIa\fR \fIb\fR
Return the remainder of the division between the two
bignums \fIa\fR and \fIb\fR\&.
.TP
\fB::math::bignum::mod\fR \fIn\fR \fIm\fR
Return \fIn\fR modulo \fIm\fR\&. This operation is
called modular reduction\&.
.TP
\fB::math::bignum::pow\fR \fIbase\fR \fIexp\fR
Return \fIbase\fR raised to the exponent \fIexp\fR\&.
.TP
\fB::math::bignum::powm\fR \fIbase\fR \fIexp\fR \fIm\fR
Return \fIbase\fR raised to the exponent \fIexp\fR,
modulo \fIm\fR\&. This function is often used in the field
of cryptography\&.
.TP
\fB::math::bignum::sqrt\fR \fIbignum\fR
Return the integer part of the square root of \fIbignum\fR
.TP
\fB::math::bignum::rand\fR \fIbits\fR
Return a random number of at most \fIbits\fR bits\&.
The returned number is internally generated using Tcl's \fIexpr rand()\fR
function and is not suitable where an unguessable and cryptographically
secure random number is needed\&.
.TP
\fB::math::bignum::lshift\fR \fIbignum\fR \fIbits\fR
Return the result of left shifting \fIbignum\fR's binary
representation of \fIbits\fR positions on the left\&.
This is equivalent to multiplying by 2^\fIbits\fR but much faster\&.
.TP
\fB::math::bignum::rshift\fR \fIbignum\fR \fIbits\fR
Return the result of right shifting \fIbignum\fR's binary
representation of \fIbits\fR positions on the right\&.
This is equivalent to dividing by \fI2^bits\fR but much faster\&.
.TP
\fB::math::bignum::bitand\fR \fIa\fR \fIb\fR
Return the result of doing a bitwise AND operation on a
and b\&. The operation is restricted to positive numbers,
including zero\&. When negative numbers are provided as
arguments the result is undefined\&.
.TP
\fB::math::bignum::bitor\fR \fIa\fR \fIb\fR
Return the result of doing a bitwise OR operation on a
and b\&. The operation is restricted to positive numbers,
including zero\&. When negative numbers are provided as
arguments the result is undefined\&.
.TP
\fB::math::bignum::bitxor\fR \fIa\fR \fIb\fR
Return the result of doing a bitwise XOR operation on a
and b\&. The operation is restricted to positive numbers,
including zero\&. When negative numbers are provided as
arguments the result is undefined\&.
.TP
\fB::math::bignum::setbit\fR \fIbignumVar\fR \fIbit\fR
Set the bit at \fIbit\fR position to 1 in the bignum stored
in the variable \fIbignumVar\fR\&. Bit 0 is the least significant\&.
.TP
\fB::math::bignum::clearbit\fR \fIbignumVar\fR \fIbit\fR
Set the bit at \fIbit\fR position to 0 in the bignum stored
in the variable \fIbignumVar\fR\&. Bit 0 is the least significant\&.
.TP
\fB::math::bignum::testbit\fR \fIbignum\fR \fIbit\fR
Return true if the bit at the \fIbit\fR position of \fIbignum\fR
is on, otherwise false is returned\&. If \fIbit\fR is out of
range, it is considered as set to zero\&.
.TP
\fB::math::bignum::bits\fR \fIbignum\fR
Return the number of bits needed to represent bignum in radix 2\&.
.PP
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fImath :: bignum\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
bignums, math, multiprecision, tcl
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2004 Salvatore Sanfilippo <antirez at invece dot org>
Copyright (c) 2004 Arjen Markus <arjenmarkus at users dot sourceforge dot net>

.fi
