# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Services.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.net


# structure
class ServiceSettings(Structure):
    idlType = "net.ServiceSettings:1.0.0"
    elements = ["service", "enable", "port"]

    def __init__(self, service, enable, port):
        typecheck.is_string(service, AssertionError)
        typecheck.is_bool(enable, AssertionError)
        typecheck.is_int(port, AssertionError)

        self.service = service
        self.enable = enable
        self.port = port

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            service = json['service'],
            enable = json['enable'],
            port = json['port'],
        )
        return obj

    def encode(self):
        json = {}
        json['service'] = self.service
        json['enable'] = self.enable
        json['port'] = self.port
        return json

# interface
class Services(Interface):
    idlType = "net.Services:1.0.0"

    ERR_INVALID_PARAMS = 1

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            servicesSettings = [raritan.rpc.net.ServiceSettings.decode(x0, agent) for x0 in rsp['servicesSettings']]
            for x0 in servicesSettings:
                typecheck.is_struct(x0, raritan.rpc.net.ServiceSettings, DecodeException)
            return servicesSettings

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(servicesSettings):
            for x0 in servicesSettings:
                typecheck.is_struct(x0, raritan.rpc.net.ServiceSettings, AssertionError)
            args = {}
            args['servicesSettings'] = [raritan.rpc.net.ServiceSettings.encode(x0) for x0 in servicesSettings]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Services, self).__init__(target, agent)
        self.getSettings = Services._getSettings(self)
        self.setSettings = Services._setSettings(self)

#
# Section generated by IdlC from "Diagnostics.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class Diagnostics(Interface):
    idlType = "net.Diagnostics:1.0.0"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_EXEC_FAIL = 2

    ERR_TIMEOUT = 3

    ERR_RESOLVE_FAIL = 4

    class _ping(Interface.Method):
        name = 'ping'

        @staticmethod
        def encode(hostName, count):
            typecheck.is_string(hostName, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['hostName'] = hostName
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _traceRoute(Interface.Method):
        name = 'traceRoute'

        @staticmethod
        def encode(hostName, timeout, useIcmp):
            typecheck.is_string(hostName, AssertionError)
            typecheck.is_int(timeout, AssertionError)
            typecheck.is_bool(useIcmp, AssertionError)
            args = {}
            args['hostName'] = hostName
            args['timeout'] = timeout
            args['useIcmp'] = useIcmp
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)

    class _listTcpConnections(Interface.Method):
        name = 'listTcpConnections'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            results = [x0 for x0 in rsp['results']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in results:
                typecheck.is_string(x0, DecodeException)
            return (_ret_, results)
    def __init__(self, target, agent):
        super(Diagnostics, self).__init__(target, agent)
        self.ping = Diagnostics._ping(self)
        self.traceRoute = Diagnostics._traceRoute(self)
        self.listTcpConnections = Diagnostics._listTcpConnections(self)

#
# Section generated by IdlC from "Net.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.net


# structure
class IpAddrCidr(Structure):
    idlType = "net.IpAddrCidr:1.0.0"
    elements = ["addr", "prefixLen"]

    def __init__(self, addr, prefixLen):
        typecheck.is_string(addr, AssertionError)
        typecheck.is_int(prefixLen, AssertionError)

        self.addr = addr
        self.prefixLen = prefixLen

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            addr = json['addr'],
            prefixLen = json['prefixLen'],
        )
        return obj

    def encode(self):
        json = {}
        json['addr'] = self.addr
        json['prefixLen'] = self.prefixLen
        return json

# structure
class IpRoute(Structure):
    idlType = "net.IpRoute:1.0.0"
    elements = ["destNetAddrCidr", "nextHopAddr", "ifName"]

    def __init__(self, destNetAddrCidr, nextHopAddr, ifName):
        typecheck.is_struct(destNetAddrCidr, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(nextHopAddr, AssertionError)
        typecheck.is_string(ifName, AssertionError)

        self.destNetAddrCidr = destNetAddrCidr
        self.nextHopAddr = nextHopAddr
        self.ifName = ifName

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            destNetAddrCidr = raritan.rpc.net.IpAddrCidr.decode(json['destNetAddrCidr'], agent),
            nextHopAddr = json['nextHopAddr'],
            ifName = json['ifName'],
        )
        return obj

    def encode(self):
        json = {}
        json['destNetAddrCidr'] = raritan.rpc.net.IpAddrCidr.encode(self.destNetAddrCidr)
        json['nextHopAddr'] = self.nextHopAddr
        json['ifName'] = self.ifName
        return json

# enumeration
class PortForwardingRole(Enumeration):
    idlType = "net.PortForwardingRole:1.0.0"
    values = ["MASTER", "SLAVE"]

PortForwardingRole.MASTER = PortForwardingRole(0)
PortForwardingRole.SLAVE = PortForwardingRole(1)

# structure
class PortForwardingSettings(Structure):
    idlType = "net.PortForwardingSettings:2.0.0"
    elements = ["enabled", "role", "masterDownstreamIfName"]

    def __init__(self, enabled, role, masterDownstreamIfName):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(role, raritan.rpc.net.PortForwardingRole, AssertionError)
        typecheck.is_string(masterDownstreamIfName, AssertionError)

        self.enabled = enabled
        self.role = role
        self.masterDownstreamIfName = masterDownstreamIfName

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            role = raritan.rpc.net.PortForwardingRole.decode(json['role']),
            masterDownstreamIfName = json['masterDownstreamIfName'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['role'] = raritan.rpc.net.PortForwardingRole.encode(self.role)
        json['masterDownstreamIfName'] = self.masterDownstreamIfName
        return json

# structure
class DnsSettings(Structure):
    idlType = "net.DnsSettings:2.0.0"
    elements = ["serverAddrs", "searchSuffixes", "resolverPrefersIPv6"]

    def __init__(self, serverAddrs, searchSuffixes, resolverPrefersIPv6):
        for x0 in serverAddrs:
            typecheck.is_string(x0, AssertionError)
        for x0 in searchSuffixes:
            typecheck.is_string(x0, AssertionError)
        typecheck.is_bool(resolverPrefersIPv6, AssertionError)

        self.serverAddrs = serverAddrs
        self.searchSuffixes = searchSuffixes
        self.resolverPrefersIPv6 = resolverPrefersIPv6

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            serverAddrs = [x0 for x0 in json['serverAddrs']],
            searchSuffixes = [x0 for x0 in json['searchSuffixes']],
            resolverPrefersIPv6 = json['resolverPrefersIPv6'],
        )
        return obj

    def encode(self):
        json = {}
        json['serverAddrs'] = [x0 for x0 in self.serverAddrs]
        json['searchSuffixes'] = [x0 for x0 in self.searchSuffixes]
        json['resolverPrefersIPv6'] = self.resolverPrefersIPv6
        return json

# structure
class IpRoutingSettings(Structure):
    idlType = "net.IpRoutingSettings:2.0.0"
    elements = ["defaultGatewayAddr", "staticRoutes"]

    def __init__(self, defaultGatewayAddr, staticRoutes):
        typecheck.is_string(defaultGatewayAddr, AssertionError)
        for x0 in staticRoutes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)

        self.defaultGatewayAddr = defaultGatewayAddr
        self.staticRoutes = staticRoutes

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            defaultGatewayAddr = json['defaultGatewayAddr'],
            staticRoutes = [raritan.rpc.net.IpRoute.decode(x0, agent) for x0 in json['staticRoutes']],
        )
        return obj

    def encode(self):
        json = {}
        json['defaultGatewayAddr'] = self.defaultGatewayAddr
        json['staticRoutes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.staticRoutes]
        return json

# structure
class RoutingSettings(Structure):
    idlType = "net.RoutingSettings:2.0.0"
    elements = ["ipv4", "ipv6"]

    def __init__(self, ipv4, ipv6):
        typecheck.is_struct(ipv4, raritan.rpc.net.IpRoutingSettings, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.IpRoutingSettings, AssertionError)

        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ipv4 = raritan.rpc.net.IpRoutingSettings.decode(json['ipv4'], agent),
            ipv6 = raritan.rpc.net.IpRoutingSettings.decode(json['ipv6'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['ipv4'] = raritan.rpc.net.IpRoutingSettings.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.IpRoutingSettings.encode(self.ipv6)
        return json

# structure
class CommonSettings(Structure):
    idlType = "net.CommonSettings:2.0.0"
    elements = ["dns", "routing", "portForwarding"]

    def __init__(self, dns, routing, portForwarding):
        typecheck.is_struct(dns, raritan.rpc.net.DnsSettings, AssertionError)
        typecheck.is_struct(routing, raritan.rpc.net.RoutingSettings, AssertionError)
        typecheck.is_struct(portForwarding, raritan.rpc.net.PortForwardingSettings, AssertionError)

        self.dns = dns
        self.routing = routing
        self.portForwarding = portForwarding

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            dns = raritan.rpc.net.DnsSettings.decode(json['dns'], agent),
            routing = raritan.rpc.net.RoutingSettings.decode(json['routing'], agent),
            portForwarding = raritan.rpc.net.PortForwardingSettings.decode(json['portForwarding'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['dns'] = raritan.rpc.net.DnsSettings.encode(self.dns)
        json['routing'] = raritan.rpc.net.RoutingSettings.encode(self.routing)
        json['portForwarding'] = raritan.rpc.net.PortForwardingSettings.encode(self.portForwarding)
        return json

# structure
class PortForwardingMasterAddrInfo(Structure):
    idlType = "net.PortForwardingMasterAddrInfo:1.0.0"
    elements = ["ifName", "addr"]

    def __init__(self, ifName, addr):
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(addr, AssertionError)

        self.ifName = ifName
        self.addr = addr

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ifName = json['ifName'],
            addr = json['addr'],
        )
        return obj

    def encode(self):
        json = {}
        json['ifName'] = self.ifName
        json['addr'] = self.addr
        return json

# structure
class PortForwardingInfo(Structure):
    idlType = "net.PortForwardingInfo:1.0.0"
    elements = ["enabled", "nodeIndexValid", "nodeIndex", "slaveConnected", "masterDownstreamIfName", "masterIPv4AddrInfos", "masterIPv6AddrInfos"]

    def __init__(self, enabled, nodeIndexValid, nodeIndex, slaveConnected, masterDownstreamIfName, masterIPv4AddrInfos, masterIPv6AddrInfos):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_bool(nodeIndexValid, AssertionError)
        typecheck.is_int(nodeIndex, AssertionError)
        typecheck.is_bool(slaveConnected, AssertionError)
        typecheck.is_string(masterDownstreamIfName, AssertionError)
        for x0 in masterIPv4AddrInfos:
            typecheck.is_struct(x0, raritan.rpc.net.PortForwardingMasterAddrInfo, AssertionError)
        for x0 in masterIPv6AddrInfos:
            typecheck.is_struct(x0, raritan.rpc.net.PortForwardingMasterAddrInfo, AssertionError)

        self.enabled = enabled
        self.nodeIndexValid = nodeIndexValid
        self.nodeIndex = nodeIndex
        self.slaveConnected = slaveConnected
        self.masterDownstreamIfName = masterDownstreamIfName
        self.masterIPv4AddrInfos = masterIPv4AddrInfos
        self.masterIPv6AddrInfos = masterIPv6AddrInfos

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            nodeIndexValid = json['nodeIndexValid'],
            nodeIndex = json['nodeIndex'],
            slaveConnected = json['slaveConnected'],
            masterDownstreamIfName = json['masterDownstreamIfName'],
            masterIPv4AddrInfos = [raritan.rpc.net.PortForwardingMasterAddrInfo.decode(x0, agent) for x0 in json['masterIPv4AddrInfos']],
            masterIPv6AddrInfos = [raritan.rpc.net.PortForwardingMasterAddrInfo.decode(x0, agent) for x0 in json['masterIPv6AddrInfos']],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['nodeIndexValid'] = self.nodeIndexValid
        json['nodeIndex'] = self.nodeIndex
        json['slaveConnected'] = self.slaveConnected
        json['masterDownstreamIfName'] = self.masterDownstreamIfName
        json['masterIPv4AddrInfos'] = [raritan.rpc.net.PortForwardingMasterAddrInfo.encode(x0) for x0 in self.masterIPv4AddrInfos]
        json['masterIPv6AddrInfos'] = [raritan.rpc.net.PortForwardingMasterAddrInfo.encode(x0) for x0 in self.masterIPv6AddrInfos]
        return json

# structure
class DnsInfo(Structure):
    idlType = "net.DnsInfo:1.0.0"
    elements = ["serverAddrs", "searchSuffixes", "resolverPrefersIPv6"]

    def __init__(self, serverAddrs, searchSuffixes, resolverPrefersIPv6):
        for x0 in serverAddrs:
            typecheck.is_string(x0, AssertionError)
        for x0 in searchSuffixes:
            typecheck.is_string(x0, AssertionError)
        typecheck.is_bool(resolverPrefersIPv6, AssertionError)

        self.serverAddrs = serverAddrs
        self.searchSuffixes = searchSuffixes
        self.resolverPrefersIPv6 = resolverPrefersIPv6

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            serverAddrs = [x0 for x0 in json['serverAddrs']],
            searchSuffixes = [x0 for x0 in json['searchSuffixes']],
            resolverPrefersIPv6 = json['resolverPrefersIPv6'],
        )
        return obj

    def encode(self):
        json = {}
        json['serverAddrs'] = [x0 for x0 in self.serverAddrs]
        json['searchSuffixes'] = [x0 for x0 in self.searchSuffixes]
        json['resolverPrefersIPv6'] = self.resolverPrefersIPv6
        return json

# structure
class RoutingInfo(Structure):
    idlType = "net.RoutingInfo:1.0.0"
    elements = ["ipv4Routes", "ipv6Routes"]

    def __init__(self, ipv4Routes, ipv6Routes):
        for x0 in ipv4Routes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)
        for x0 in ipv6Routes:
            typecheck.is_struct(x0, raritan.rpc.net.IpRoute, AssertionError)

        self.ipv4Routes = ipv4Routes
        self.ipv6Routes = ipv6Routes

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ipv4Routes = [raritan.rpc.net.IpRoute.decode(x0, agent) for x0 in json['ipv4Routes']],
            ipv6Routes = [raritan.rpc.net.IpRoute.decode(x0, agent) for x0 in json['ipv6Routes']],
        )
        return obj

    def encode(self):
        json = {}
        json['ipv4Routes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.ipv4Routes]
        json['ipv6Routes'] = [raritan.rpc.net.IpRoute.encode(x0) for x0 in self.ipv6Routes]
        return json

# structure
class CommonInfo(Structure):
    idlType = "net.CommonInfo:1.0.0"
    elements = ["dns", "routing", "portForwarding"]

    def __init__(self, dns, routing, portForwarding):
        typecheck.is_struct(dns, raritan.rpc.net.DnsInfo, AssertionError)
        typecheck.is_struct(routing, raritan.rpc.net.RoutingInfo, AssertionError)
        typecheck.is_struct(portForwarding, raritan.rpc.net.PortForwardingInfo, AssertionError)

        self.dns = dns
        self.routing = routing
        self.portForwarding = portForwarding

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            dns = raritan.rpc.net.DnsInfo.decode(json['dns'], agent),
            routing = raritan.rpc.net.RoutingInfo.decode(json['routing'], agent),
            portForwarding = raritan.rpc.net.PortForwardingInfo.decode(json['portForwarding'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['dns'] = raritan.rpc.net.DnsInfo.encode(self.dns)
        json['routing'] = raritan.rpc.net.RoutingInfo.encode(self.routing)
        json['portForwarding'] = raritan.rpc.net.PortForwardingInfo.encode(self.portForwarding)
        return json

# enumeration
class IpConfigMethod(Enumeration):
    idlType = "net.IpConfigMethod:1.0.0"
    values = ["STATIC", "DHCP", "AUTO"]

IpConfigMethod.STATIC = IpConfigMethod(0)
IpConfigMethod.DHCP = IpConfigMethod(1)
IpConfigMethod.AUTO = IpConfigMethod(2)

# structure
class InterfaceIpSettings(Structure):
    idlType = "net.InterfaceIpSettings:2.0.0"
    elements = ["enabled", "configMethod", "staticAddrCidr", "dhcpPreferredHostname"]

    def __init__(self, enabled, configMethod, staticAddrCidr, dhcpPreferredHostname):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        typecheck.is_struct(staticAddrCidr, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.staticAddrCidr = staticAddrCidr
        self.dhcpPreferredHostname = dhcpPreferredHostname

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']),
            staticAddrCidr = raritan.rpc.net.IpAddrCidr.decode(json['staticAddrCidr'], agent),
            dhcpPreferredHostname = json['dhcpPreferredHostname'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['staticAddrCidr'] = raritan.rpc.net.IpAddrCidr.encode(self.staticAddrCidr)
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        return json

# structure
class InterfaceIPv4Info(Structure):
    idlType = "net.InterfaceIPv4Info:1.0.0"
    elements = ["enabled", "configMethod", "addrsCidr", "dhcpServerAddr", "dhcpPreferredHostname"]

    def __init__(self, enabled, configMethod, addrsCidr, dhcpServerAddr, dhcpPreferredHostname):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        for x0 in addrsCidr:
            typecheck.is_struct(x0, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(dhcpServerAddr, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.addrsCidr = addrsCidr
        self.dhcpServerAddr = dhcpServerAddr
        self.dhcpPreferredHostname = dhcpPreferredHostname

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']),
            addrsCidr = [raritan.rpc.net.IpAddrCidr.decode(x0, agent) for x0 in json['addrsCidr']],
            dhcpServerAddr = json['dhcpServerAddr'],
            dhcpPreferredHostname = json['dhcpPreferredHostname'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['addrsCidr'] = [raritan.rpc.net.IpAddrCidr.encode(x0) for x0 in self.addrsCidr]
        json['dhcpServerAddr'] = self.dhcpServerAddr
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        return json

# structure
class InterfaceIPv6Info(Structure):
    idlType = "net.InterfaceIPv6Info:1.0.0"
    elements = ["enabled", "configMethod", "addrsCidr", "dhcpServerId", "dhcpPreferredHostname", "raManaged", "raOtherConf"]

    def __init__(self, enabled, configMethod, addrsCidr, dhcpServerId, dhcpPreferredHostname, raManaged, raOtherConf):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(configMethod, raritan.rpc.net.IpConfigMethod, AssertionError)
        for x0 in addrsCidr:
            typecheck.is_struct(x0, raritan.rpc.net.IpAddrCidr, AssertionError)
        typecheck.is_string(dhcpServerId, AssertionError)
        typecheck.is_string(dhcpPreferredHostname, AssertionError)
        typecheck.is_bool(raManaged, AssertionError)
        typecheck.is_bool(raOtherConf, AssertionError)

        self.enabled = enabled
        self.configMethod = configMethod
        self.addrsCidr = addrsCidr
        self.dhcpServerId = dhcpServerId
        self.dhcpPreferredHostname = dhcpPreferredHostname
        self.raManaged = raManaged
        self.raOtherConf = raOtherConf

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            configMethod = raritan.rpc.net.IpConfigMethod.decode(json['configMethod']),
            addrsCidr = [raritan.rpc.net.IpAddrCidr.decode(x0, agent) for x0 in json['addrsCidr']],
            dhcpServerId = json['dhcpServerId'],
            dhcpPreferredHostname = json['dhcpPreferredHostname'],
            raManaged = json['raManaged'],
            raOtherConf = json['raOtherConf'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['configMethod'] = raritan.rpc.net.IpConfigMethod.encode(self.configMethod)
        json['addrsCidr'] = [raritan.rpc.net.IpAddrCidr.encode(x0) for x0 in self.addrsCidr]
        json['dhcpServerId'] = self.dhcpServerId
        json['dhcpPreferredHostname'] = self.dhcpPreferredHostname
        json['raManaged'] = self.raManaged
        json['raOtherConf'] = self.raOtherConf
        return json

# structure
class InterfaceSettings(Structure):
    idlType = "net.InterfaceSettings:2.0.0"
    elements = ["enabled", "ipv4", "ipv6"]

    def __init__(self, enabled, ipv4, ipv6):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_struct(ipv4, raritan.rpc.net.InterfaceIpSettings, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.InterfaceIpSettings, AssertionError)

        self.enabled = enabled
        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            ipv4 = raritan.rpc.net.InterfaceIpSettings.decode(json['ipv4'], agent),
            ipv6 = raritan.rpc.net.InterfaceIpSettings.decode(json['ipv6'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['ipv4'] = raritan.rpc.net.InterfaceIpSettings.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.InterfaceIpSettings.encode(self.ipv6)
        return json

# enumeration
class InterfaceType(Enumeration):
    idlType = "net.InterfaceType:1.0.0"
    values = ["ETHERNET", "WLAN", "BRIDGE"]

InterfaceType.ETHERNET = InterfaceType(0)
InterfaceType.WLAN = InterfaceType(1)
InterfaceType.BRIDGE = InterfaceType(2)

# enumeration
class InterfaceOpState(Enumeration):
    idlType = "net.InterfaceOpState:1.0.0"
    values = ["NOT_PRESENT", "DOWN", "NO_LINK", "UP"]

InterfaceOpState.NOT_PRESENT = InterfaceOpState(0)
InterfaceOpState.DOWN = InterfaceOpState(1)
InterfaceOpState.NO_LINK = InterfaceOpState(2)
InterfaceOpState.UP = InterfaceOpState(3)

# structure
class InterfaceInfo(Structure):
    idlType = "net.InterfaceInfo:1.0.0"
    elements = ["name", "label", "type", "enabled", "masterIfName", "state", "macAddr", "ipv4", "ipv6"]

    def __init__(self, name, label, type, enabled, masterIfName, state, macAddr, ipv4, ipv6):
        typecheck.is_string(name, AssertionError)
        typecheck.is_string(label, AssertionError)
        typecheck.is_enum(type, raritan.rpc.net.InterfaceType, AssertionError)
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_string(masterIfName, AssertionError)
        typecheck.is_enum(state, raritan.rpc.net.InterfaceOpState, AssertionError)
        typecheck.is_string(macAddr, AssertionError)
        typecheck.is_struct(ipv4, raritan.rpc.net.InterfaceIPv4Info, AssertionError)
        typecheck.is_struct(ipv6, raritan.rpc.net.InterfaceIPv6Info, AssertionError)

        self.name = name
        self.label = label
        self.type = type
        self.enabled = enabled
        self.masterIfName = masterIfName
        self.state = state
        self.macAddr = macAddr
        self.ipv4 = ipv4
        self.ipv6 = ipv6

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            name = json['name'],
            label = json['label'],
            type = raritan.rpc.net.InterfaceType.decode(json['type']),
            enabled = json['enabled'],
            masterIfName = json['masterIfName'],
            state = raritan.rpc.net.InterfaceOpState.decode(json['state']),
            macAddr = json['macAddr'],
            ipv4 = raritan.rpc.net.InterfaceIPv4Info.decode(json['ipv4'], agent),
            ipv6 = raritan.rpc.net.InterfaceIPv6Info.decode(json['ipv6'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['name'] = self.name
        json['label'] = self.label
        json['type'] = raritan.rpc.net.InterfaceType.encode(self.type)
        json['enabled'] = self.enabled
        json['masterIfName'] = self.masterIfName
        json['state'] = raritan.rpc.net.InterfaceOpState.encode(self.state)
        json['macAddr'] = self.macAddr
        json['ipv4'] = raritan.rpc.net.InterfaceIPv4Info.encode(self.ipv4)
        json['ipv6'] = raritan.rpc.net.InterfaceIPv6Info.encode(self.ipv6)
        return json

# enumeration
class EapOuterAuthMethod(Enumeration):
    idlType = "net.EapOuterAuthMethod:2.0.0"
    values = ["EAP_PEAP", "EAP_TLS"]

EapOuterAuthMethod.EAP_PEAP = EapOuterAuthMethod(0)
EapOuterAuthMethod.EAP_TLS = EapOuterAuthMethod(1)

# enumeration
class EapInnerAuthMethod(Enumeration):
    idlType = "net.EapInnerAuthMethod:2.0.0"
    values = ["INNER_EAP_MSCHAPv2", "INNER_EAP_TLS"]

EapInnerAuthMethod.INNER_EAP_MSCHAPv2 = EapInnerAuthMethod(0)
EapInnerAuthMethod.INNER_EAP_TLS = EapInnerAuthMethod(1)

# enumeration
class EapStatus(Enumeration):
    idlType = "net.EapStatus:1.0.0"
    values = ["EAP_STATUS_DISABLED", "EAP_STATUS_PENDING", "EAP_STATUS_FAILED", "EAP_STATUS_SUCCESS"]

EapStatus.EAP_STATUS_DISABLED = EapStatus(0)
EapStatus.EAP_STATUS_PENDING = EapStatus(1)
EapStatus.EAP_STATUS_FAILED = EapStatus(2)
EapStatus.EAP_STATUS_SUCCESS = EapStatus(3)

# structure
class EapAuthSettings(Structure):
    idlType = "net.EapAuthSettings:3.0.0"
    elements = ["identity", "password", "clearPassword", "clientCertChain", "clientPrivKey", "clearClientPrivKey", "clientPrivKeyPassword", "outerMethod", "innerMethod", "caCertChain", "forceTrustedCert", "allowOffTimeRangeCerts", "allowNotYetValidCertsIfTimeBeforeBuild", "authServerName"]

    def __init__(self, identity, password, clearPassword, clientCertChain, clientPrivKey, clearClientPrivKey, clientPrivKeyPassword, outerMethod, innerMethod, caCertChain, forceTrustedCert, allowOffTimeRangeCerts, allowNotYetValidCertsIfTimeBeforeBuild, authServerName):
        typecheck.is_string(identity, AssertionError)
        typecheck.is_string(password, AssertionError)
        typecheck.is_bool(clearPassword, AssertionError)
        typecheck.is_string(clientCertChain, AssertionError)
        typecheck.is_string(clientPrivKey, AssertionError)
        typecheck.is_bool(clearClientPrivKey, AssertionError)
        typecheck.is_string(clientPrivKeyPassword, AssertionError)
        typecheck.is_enum(outerMethod, raritan.rpc.net.EapOuterAuthMethod, AssertionError)
        typecheck.is_enum(innerMethod, raritan.rpc.net.EapInnerAuthMethod, AssertionError)
        typecheck.is_string(caCertChain, AssertionError)
        typecheck.is_bool(forceTrustedCert, AssertionError)
        typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)
        typecheck.is_bool(allowNotYetValidCertsIfTimeBeforeBuild, AssertionError)
        typecheck.is_string(authServerName, AssertionError)

        self.identity = identity
        self.password = password
        self.clearPassword = clearPassword
        self.clientCertChain = clientCertChain
        self.clientPrivKey = clientPrivKey
        self.clearClientPrivKey = clearClientPrivKey
        self.clientPrivKeyPassword = clientPrivKeyPassword
        self.outerMethod = outerMethod
        self.innerMethod = innerMethod
        self.caCertChain = caCertChain
        self.forceTrustedCert = forceTrustedCert
        self.allowOffTimeRangeCerts = allowOffTimeRangeCerts
        self.allowNotYetValidCertsIfTimeBeforeBuild = allowNotYetValidCertsIfTimeBeforeBuild
        self.authServerName = authServerName

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            identity = json['identity'],
            password = json['password'],
            clearPassword = json['clearPassword'],
            clientCertChain = json['clientCertChain'],
            clientPrivKey = json['clientPrivKey'],
            clearClientPrivKey = json['clearClientPrivKey'],
            clientPrivKeyPassword = json['clientPrivKeyPassword'],
            outerMethod = raritan.rpc.net.EapOuterAuthMethod.decode(json['outerMethod']),
            innerMethod = raritan.rpc.net.EapInnerAuthMethod.decode(json['innerMethod']),
            caCertChain = json['caCertChain'],
            forceTrustedCert = json['forceTrustedCert'],
            allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'],
            allowNotYetValidCertsIfTimeBeforeBuild = json['allowNotYetValidCertsIfTimeBeforeBuild'],
            authServerName = json['authServerName'],
        )
        return obj

    def encode(self):
        json = {}
        json['identity'] = self.identity
        json['password'] = self.password
        json['clearPassword'] = self.clearPassword
        json['clientCertChain'] = self.clientCertChain
        json['clientPrivKey'] = self.clientPrivKey
        json['clearClientPrivKey'] = self.clearClientPrivKey
        json['clientPrivKeyPassword'] = self.clientPrivKeyPassword
        json['outerMethod'] = raritan.rpc.net.EapOuterAuthMethod.encode(self.outerMethod)
        json['innerMethod'] = raritan.rpc.net.EapInnerAuthMethod.encode(self.innerMethod)
        json['caCertChain'] = self.caCertChain
        json['forceTrustedCert'] = self.forceTrustedCert
        json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
        json['allowNotYetValidCertsIfTimeBeforeBuild'] = self.allowNotYetValidCertsIfTimeBeforeBuild
        json['authServerName'] = self.authServerName
        return json

# enumeration
class EthSpeed(Enumeration):
    idlType = "net.EthSpeed:1.0.0"
    values = ["SPEED_AUTO", "SPEED_MBIT_10", "SPEED_MBIT_100", "SPEED_MBIT_1000"]

EthSpeed.SPEED_AUTO = EthSpeed(0)
EthSpeed.SPEED_MBIT_10 = EthSpeed(1)
EthSpeed.SPEED_MBIT_100 = EthSpeed(2)
EthSpeed.SPEED_MBIT_1000 = EthSpeed(3)

# enumeration
class EthDuplexMode(Enumeration):
    idlType = "net.EthDuplexMode:1.0.0"
    values = ["DUPLEX_MODE_AUTO", "DUPLEX_MODE_HALF", "DUPLEX_MODE_FULL"]

EthDuplexMode.DUPLEX_MODE_AUTO = EthDuplexMode(0)
EthDuplexMode.DUPLEX_MODE_HALF = EthDuplexMode(1)
EthDuplexMode.DUPLEX_MODE_FULL = EthDuplexMode(2)

# enumeration
class EthAuthType(Enumeration):
    idlType = "net.EthAuthType:1.0.0"
    values = ["ETH_AUTH_NONE", "ETH_AUTH_EAP"]

EthAuthType.ETH_AUTH_NONE = EthAuthType(0)
EthAuthType.ETH_AUTH_EAP = EthAuthType(1)

# structure
class EthLinkMode(Structure):
    idlType = "net.EthLinkMode:1.0.0"
    elements = ["speed", "duplexMode"]

    def __init__(self, speed, duplexMode):
        typecheck.is_enum(speed, raritan.rpc.net.EthSpeed, AssertionError)
        typecheck.is_enum(duplexMode, raritan.rpc.net.EthDuplexMode, AssertionError)

        self.speed = speed
        self.duplexMode = duplexMode

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            speed = raritan.rpc.net.EthSpeed.decode(json['speed']),
            duplexMode = raritan.rpc.net.EthDuplexMode.decode(json['duplexMode']),
        )
        return obj

    def encode(self):
        json = {}
        json['speed'] = raritan.rpc.net.EthSpeed.encode(self.speed)
        json['duplexMode'] = raritan.rpc.net.EthDuplexMode.encode(self.duplexMode)
        return json

# structure
class EthSettings(Structure):
    idlType = "net.EthSettings:2.0.0"
    elements = ["linkMode", "authType", "eap"]

    def __init__(self, linkMode, authType, eap):
        typecheck.is_struct(linkMode, raritan.rpc.net.EthLinkMode, AssertionError)
        typecheck.is_enum(authType, raritan.rpc.net.EthAuthType, AssertionError)
        typecheck.is_struct(eap, raritan.rpc.net.EapAuthSettings, AssertionError)

        self.linkMode = linkMode
        self.authType = authType
        self.eap = eap

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            linkMode = raritan.rpc.net.EthLinkMode.decode(json['linkMode'], agent),
            authType = raritan.rpc.net.EthAuthType.decode(json['authType']),
            eap = raritan.rpc.net.EapAuthSettings.decode(json['eap'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['linkMode'] = raritan.rpc.net.EthLinkMode.encode(self.linkMode)
        json['authType'] = raritan.rpc.net.EthAuthType.encode(self.authType)
        json['eap'] = raritan.rpc.net.EapAuthSettings.encode(self.eap)
        return json

# structure
class EthInfo(Structure):
    idlType = "net.EthInfo:1.0.1"
    elements = ["eapStatus", "linkMode", "linkModeValid", "autonegEnabled", "linkDetected", "supportedLinkModes"]

    def __init__(self, eapStatus, linkMode, linkModeValid, autonegEnabled, linkDetected, supportedLinkModes):
        typecheck.is_enum(eapStatus, raritan.rpc.net.EapStatus, AssertionError)
        typecheck.is_struct(linkMode, raritan.rpc.net.EthLinkMode, AssertionError)
        typecheck.is_bool(linkModeValid, AssertionError)
        typecheck.is_bool(autonegEnabled, AssertionError)
        typecheck.is_bool(linkDetected, AssertionError)
        for x0 in supportedLinkModes:
            typecheck.is_struct(x0, raritan.rpc.net.EthLinkMode, AssertionError)

        self.eapStatus = eapStatus
        self.linkMode = linkMode
        self.linkModeValid = linkModeValid
        self.autonegEnabled = autonegEnabled
        self.linkDetected = linkDetected
        self.supportedLinkModes = supportedLinkModes

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            eapStatus = raritan.rpc.net.EapStatus.decode(json['eapStatus']),
            linkMode = raritan.rpc.net.EthLinkMode.decode(json['linkMode'], agent),
            linkModeValid = json['linkModeValid'],
            autonegEnabled = json['autonegEnabled'],
            linkDetected = json['linkDetected'],
            supportedLinkModes = [raritan.rpc.net.EthLinkMode.decode(x0, agent) for x0 in json['supportedLinkModes']],
        )
        return obj

    def encode(self):
        json = {}
        json['eapStatus'] = raritan.rpc.net.EapStatus.encode(self.eapStatus)
        json['linkMode'] = raritan.rpc.net.EthLinkMode.encode(self.linkMode)
        json['linkModeValid'] = self.linkModeValid
        json['autonegEnabled'] = self.autonegEnabled
        json['linkDetected'] = self.linkDetected
        json['supportedLinkModes'] = [raritan.rpc.net.EthLinkMode.encode(x0) for x0 in self.supportedLinkModes]
        return json

# enumeration
class WlanSecProtocol(Enumeration):
    idlType = "net.WlanSecProtocol:1.0.0"
    values = ["WPA2"]

WlanSecProtocol.WPA2 = WlanSecProtocol(0)

# enumeration
class WlanAuthType(Enumeration):
    idlType = "net.WlanAuthType:2.0.0"
    values = ["WLAN_AUTH_NONE", "WLAN_AUTH_PSK", "WLAN_AUTH_EAP"]

WlanAuthType.WLAN_AUTH_NONE = WlanAuthType(0)
WlanAuthType.WLAN_AUTH_PSK = WlanAuthType(1)
WlanAuthType.WLAN_AUTH_EAP = WlanAuthType(2)

# structure
class WlanSettings(Structure):
    idlType = "net.WlanSettings:3.0.0"
    elements = ["enableHT", "ssid", "bssid", "secProtocol", "authType", "psk", "clearPsk", "eap"]

    def __init__(self, enableHT, ssid, bssid, secProtocol, authType, psk, clearPsk, eap):
        typecheck.is_bool(enableHT, AssertionError)
        typecheck.is_string(ssid, AssertionError)
        typecheck.is_string(bssid, AssertionError)
        typecheck.is_enum(secProtocol, raritan.rpc.net.WlanSecProtocol, AssertionError)
        typecheck.is_enum(authType, raritan.rpc.net.WlanAuthType, AssertionError)
        typecheck.is_string(psk, AssertionError)
        typecheck.is_bool(clearPsk, AssertionError)
        typecheck.is_struct(eap, raritan.rpc.net.EapAuthSettings, AssertionError)

        self.enableHT = enableHT
        self.ssid = ssid
        self.bssid = bssid
        self.secProtocol = secProtocol
        self.authType = authType
        self.psk = psk
        self.clearPsk = clearPsk
        self.eap = eap

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enableHT = json['enableHT'],
            ssid = json['ssid'],
            bssid = json['bssid'],
            secProtocol = raritan.rpc.net.WlanSecProtocol.decode(json['secProtocol']),
            authType = raritan.rpc.net.WlanAuthType.decode(json['authType']),
            psk = json['psk'],
            clearPsk = json['clearPsk'],
            eap = raritan.rpc.net.EapAuthSettings.decode(json['eap'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['enableHT'] = self.enableHT
        json['ssid'] = self.ssid
        json['bssid'] = self.bssid
        json['secProtocol'] = raritan.rpc.net.WlanSecProtocol.encode(self.secProtocol)
        json['authType'] = raritan.rpc.net.WlanAuthType.encode(self.authType)
        json['psk'] = self.psk
        json['clearPsk'] = self.clearPsk
        json['eap'] = raritan.rpc.net.EapAuthSettings.encode(self.eap)
        return json

# enumeration
class WlanChannelWidth(Enumeration):
    idlType = "net.WlanChannelWidth:1.0.0"
    values = ["CHANNEL_WIDTH_UNKNOWN", "CHANNEL_WIDTH_20_NO_HT", "CHANNEL_WIDTH_20", "CHANNEL_WIDTH_40", "CHANNEL_WIDTH_80", "CHANNEL_WIDTH_80P80", "CHANNEL_WIDTH_160"]

WlanChannelWidth.CHANNEL_WIDTH_UNKNOWN = WlanChannelWidth(0)
WlanChannelWidth.CHANNEL_WIDTH_20_NO_HT = WlanChannelWidth(1)
WlanChannelWidth.CHANNEL_WIDTH_20 = WlanChannelWidth(2)
WlanChannelWidth.CHANNEL_WIDTH_40 = WlanChannelWidth(3)
WlanChannelWidth.CHANNEL_WIDTH_80 = WlanChannelWidth(4)
WlanChannelWidth.CHANNEL_WIDTH_80P80 = WlanChannelWidth(5)
WlanChannelWidth.CHANNEL_WIDTH_160 = WlanChannelWidth(6)

# structure
class WlanInfo(Structure):
    idlType = "net.WlanInfo:1.0.0"
    elements = ["associated", "ssid", "bssid", "channel", "channelWidth"]

    def __init__(self, associated, ssid, bssid, channel, channelWidth):
        typecheck.is_bool(associated, AssertionError)
        typecheck.is_string(ssid, AssertionError)
        typecheck.is_string(bssid, AssertionError)
        typecheck.is_int(channel, AssertionError)
        typecheck.is_enum(channelWidth, raritan.rpc.net.WlanChannelWidth, AssertionError)

        self.associated = associated
        self.ssid = ssid
        self.bssid = bssid
        self.channel = channel
        self.channelWidth = channelWidth

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            associated = json['associated'],
            ssid = json['ssid'],
            bssid = json['bssid'],
            channel = json['channel'],
            channelWidth = raritan.rpc.net.WlanChannelWidth.decode(json['channelWidth']),
        )
        return obj

    def encode(self):
        json = {}
        json['associated'] = self.associated
        json['ssid'] = self.ssid
        json['bssid'] = self.bssid
        json['channel'] = self.channel
        json['channelWidth'] = raritan.rpc.net.WlanChannelWidth.encode(self.channelWidth)
        return json

# structure
class Settings(Structure):
    idlType = "net.Settings:3.0.0"
    elements = ["common", "ifMap", "ethMap", "wlanMap"]

    def __init__(self, common, ifMap, ethMap, wlanMap):
        typecheck.is_struct(common, raritan.rpc.net.CommonSettings, AssertionError)

        self.common = common
        self.ifMap = ifMap
        self.ethMap = ethMap
        self.wlanMap = wlanMap

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            common = raritan.rpc.net.CommonSettings.decode(json['common'], agent),
            ifMap = dict([(
                elem['key'],
                raritan.rpc.net.InterfaceSettings.decode(elem['value'], agent))
                for elem in json['ifMap']]),
            ethMap = dict([(
                elem['key'],
                raritan.rpc.net.EthSettings.decode(elem['value'], agent))
                for elem in json['ethMap']]),
            wlanMap = dict([(
                elem['key'],
                raritan.rpc.net.WlanSettings.decode(elem['value'], agent))
                for elem in json['wlanMap']]),
        )
        return obj

    def encode(self):
        json = {}
        json['common'] = raritan.rpc.net.CommonSettings.encode(self.common)
        json['ifMap'] = [dict(
            key = k,
            value = raritan.rpc.net.InterfaceSettings.encode(v))
            for k, v in self.ifMap.items()]
        json['ethMap'] = [dict(
            key = k,
            value = raritan.rpc.net.EthSettings.encode(v))
            for k, v in self.ethMap.items()]
        json['wlanMap'] = [dict(
            key = k,
            value = raritan.rpc.net.WlanSettings.encode(v))
            for k, v in self.wlanMap.items()]
        return json

# structure
class Info(Structure):
    idlType = "net.Info:1.0.1"
    elements = ["common", "ifMap", "ethMap", "wlanMap"]

    def __init__(self, common, ifMap, ethMap, wlanMap):
        typecheck.is_struct(common, raritan.rpc.net.CommonInfo, AssertionError)

        self.common = common
        self.ifMap = ifMap
        self.ethMap = ethMap
        self.wlanMap = wlanMap

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            common = raritan.rpc.net.CommonInfo.decode(json['common'], agent),
            ifMap = dict([(
                elem['key'],
                raritan.rpc.net.InterfaceInfo.decode(elem['value'], agent))
                for elem in json['ifMap']]),
            ethMap = dict([(
                elem['key'],
                raritan.rpc.net.EthInfo.decode(elem['value'], agent))
                for elem in json['ethMap']]),
            wlanMap = dict([(
                elem['key'],
                raritan.rpc.net.WlanInfo.decode(elem['value'], agent))
                for elem in json['wlanMap']]),
        )
        return obj

    def encode(self):
        json = {}
        json['common'] = raritan.rpc.net.CommonInfo.encode(self.common)
        json['ifMap'] = [dict(
            key = k,
            value = raritan.rpc.net.InterfaceInfo.encode(v))
            for k, v in self.ifMap.items()]
        json['ethMap'] = [dict(
            key = k,
            value = raritan.rpc.net.EthInfo.encode(v))
            for k, v in self.ethMap.items()]
        json['wlanMap'] = [dict(
            key = k,
            value = raritan.rpc.net.WlanInfo.encode(v))
            for k, v in self.wlanMap.items()]
        return json

# structure
class PortForwardingProtocolMapping(Structure):
    idlType = "net.PortForwardingProtocolMapping:1.0.0"
    elements = ["appProtoId", "appProtoName", "transportProtoName"]

    def __init__(self, appProtoId, appProtoName, transportProtoName):
        typecheck.is_int(appProtoId, AssertionError)
        typecheck.is_string(appProtoName, AssertionError)
        typecheck.is_string(transportProtoName, AssertionError)

        self.appProtoId = appProtoId
        self.appProtoName = appProtoName
        self.transportProtoName = transportProtoName

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            appProtoId = json['appProtoId'],
            appProtoName = json['appProtoName'],
            transportProtoName = json['transportProtoName'],
        )
        return obj

    def encode(self):
        json = {}
        json['appProtoId'] = self.appProtoId
        json['appProtoName'] = self.appProtoName
        json['transportProtoName'] = self.transportProtoName
        return json

# value object
class CommonInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.CommonInfoChangedEvent:1.0.0"

    def __init__(self, commonInfo, source):
        super(raritan.rpc.net.CommonInfoChangedEvent, self).__init__(source)
        typecheck.is_struct(commonInfo, raritan.rpc.net.CommonInfo, AssertionError)

        self.commonInfo = commonInfo

    def encode(self):
        json = super(raritan.rpc.net.CommonInfoChangedEvent, self).encode()
        json['commonInfo'] = raritan.rpc.net.CommonInfo.encode(self.commonInfo)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            commonInfo = raritan.rpc.net.CommonInfo.decode(json['commonInfo'], agent),
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["commonInfo"]
        elements = elements + super(raritan.rpc.net.CommonInfoChangedEvent, self).listElements()
        return elements

# value object
class InterfaceInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.InterfaceInfoChangedEvent:1.0.0"

    def __init__(self, ifInfo, source):
        super(raritan.rpc.net.InterfaceInfoChangedEvent, self).__init__(source)
        typecheck.is_struct(ifInfo, raritan.rpc.net.InterfaceInfo, AssertionError)

        self.ifInfo = ifInfo

    def encode(self):
        json = super(raritan.rpc.net.InterfaceInfoChangedEvent, self).encode()
        json['ifInfo'] = raritan.rpc.net.InterfaceInfo.encode(self.ifInfo)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ifInfo = raritan.rpc.net.InterfaceInfo.decode(json['ifInfo'], agent),
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["ifInfo"]
        elements = elements + super(raritan.rpc.net.InterfaceInfoChangedEvent, self).listElements()
        return elements

# value object
class EthInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.EthInfoChangedEvent:1.0.1"

    def __init__(self, ifName, ifLabel, ethInfo, source):
        super(raritan.rpc.net.EthInfoChangedEvent, self).__init__(source)
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(ifLabel, AssertionError)
        typecheck.is_struct(ethInfo, raritan.rpc.net.EthInfo, AssertionError)

        self.ifName = ifName
        self.ifLabel = ifLabel
        self.ethInfo = ethInfo

    def encode(self):
        json = super(raritan.rpc.net.EthInfoChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['ifLabel'] = self.ifLabel
        json['ethInfo'] = raritan.rpc.net.EthInfo.encode(self.ethInfo)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ifName = json['ifName'],
            ifLabel = json['ifLabel'],
            ethInfo = raritan.rpc.net.EthInfo.decode(json['ethInfo'], agent),
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["ifName", "ifLabel", "ethInfo"]
        elements = elements + super(raritan.rpc.net.EthInfoChangedEvent, self).listElements()
        return elements

# value object
class WlanInfoChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.WlanInfoChangedEvent:1.0.0"

    def __init__(self, ifName, wlanInfo, source):
        super(raritan.rpc.net.WlanInfoChangedEvent, self).__init__(source)
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_struct(wlanInfo, raritan.rpc.net.WlanInfo, AssertionError)

        self.ifName = ifName
        self.wlanInfo = wlanInfo

    def encode(self):
        json = super(raritan.rpc.net.WlanInfoChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['wlanInfo'] = raritan.rpc.net.WlanInfo.encode(self.wlanInfo)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ifName = json['ifName'],
            wlanInfo = raritan.rpc.net.WlanInfo.decode(json['wlanInfo'], agent),
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["ifName", "wlanInfo"]
        elements = elements + super(raritan.rpc.net.WlanInfoChangedEvent, self).listElements()
        return elements

# value object
class LinkStateChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.LinkStateChangedEvent:1.0.0"

    def __init__(self, ifName, ifLabel, ifType, ifState, source):
        super(raritan.rpc.net.LinkStateChangedEvent, self).__init__(source)
        typecheck.is_string(ifName, AssertionError)
        typecheck.is_string(ifLabel, AssertionError)
        typecheck.is_enum(ifType, raritan.rpc.net.InterfaceType, AssertionError)
        typecheck.is_enum(ifState, raritan.rpc.net.InterfaceOpState, AssertionError)

        self.ifName = ifName
        self.ifLabel = ifLabel
        self.ifType = ifType
        self.ifState = ifState

    def encode(self):
        json = super(raritan.rpc.net.LinkStateChangedEvent, self).encode()
        json['ifName'] = self.ifName
        json['ifLabel'] = self.ifLabel
        json['ifType'] = raritan.rpc.net.InterfaceType.encode(self.ifType)
        json['ifState'] = raritan.rpc.net.InterfaceOpState.encode(self.ifState)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ifName = json['ifName'],
            ifLabel = json['ifLabel'],
            ifType = raritan.rpc.net.InterfaceType.decode(json['ifType']),
            ifState = raritan.rpc.net.InterfaceOpState.decode(json['ifState']),
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["ifName", "ifLabel", "ifType", "ifState"]
        elements = elements + super(raritan.rpc.net.LinkStateChangedEvent, self).listElements()
        return elements

# value object
class PortForwardingSlavePresenceStateChangedEvent(raritan.rpc.idl.Event):
    idlType = "net.PortForwardingSlavePresenceStateChangedEvent:1.0.0"

    def __init__(self, slavePresent, source):
        super(raritan.rpc.net.PortForwardingSlavePresenceStateChangedEvent, self).__init__(source)
        typecheck.is_bool(slavePresent, AssertionError)

        self.slavePresent = slavePresent

    def encode(self):
        json = super(raritan.rpc.net.PortForwardingSlavePresenceStateChangedEvent, self).encode()
        json['slavePresent'] = self.slavePresent
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            slavePresent = json['slavePresent'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["slavePresent"]
        elements = elements + super(raritan.rpc.net.PortForwardingSlavePresenceStateChangedEvent, self).listElements()
        return elements

# interface
class Net(Interface):
    idlType = "net.Net:5.0.0"

    SUCCESS = 0

    ERR_DNS_TOO_MANY_SERVERS = 100

    ERR_DNS_INVALID_SERVER = 101

    ERR_DNS_TOO_MANY_SEARCH_SUFFIXES = 102

    ERR_DNS_INVALID_SEARCH_SUFFIX = 103

    ERR_ROUTING_IPV4_INVALID_DFLT_GATEWAY_ADDR = 200

    ERR_ROUTING_IPV6_INVALID_DFLT_GATEWAY_ADDR = 201

    ERR_ROUTING_IPV4_INVALID_DEST_ADDR = 202

    ERR_ROUTING_IPV6_INVALID_DEST_ADDR = 203

    ERR_ROUTING_IPV4_INVALID_DEST_PREFIX_LEN = 204

    ERR_ROUTING_IPV6_INVALID_DEST_PREFIX_LEN = 205

    ERR_ROUTING_IPV4_INVALID_NEXTHOP_ADDR = 206

    ERR_ROUTING_IPV6_INVALID_NEXTHOP_ADDR = 207

    ERR_ROUTING_IPV4_INVALID_INTERFACE = 208

    ERR_ROUTING_IPV6_INVALID_INTERFACE = 209

    ERR_ROUTING_IPV4_DEST_IS_NO_NETWORK_ADDR = 210

    ERR_ROUTING_IPV6_DEST_IS_NO_NETWORK_ADDR = 211

    ERR_ROUTING_IPV4_DEST_IS_DUPLICATE = 212

    ERR_ROUTING_IPV6_DEST_IS_DUPLICATE = 213

    ERR_ROUTING_IPV4_NO_NEXTHOP_OR_INTERFACE = 214

    ERR_ROUTING_IPV6_NO_NEXTHOP_OR_INTERFACE = 215

    ERR_ROUTING_IPV4_NEXTHOP_AND_INTERFACE_SET = 216

    ERR_ROUTING_IPV6_NEXTHOP_AND_INTERFACE_SET = 217

    ERR_PF_INVALID_MASTER_DOWNSTREAM_INTERFACE = 300

    ERR_PF_NO_WORKING_MASTER_UPSTREAM_INTERFACE = 301

    ERR_IF_IPV4_INVALID_CONFIG_METHOD = 400

    ERR_IF_IPV6_INVALID_CONFIG_METHOD = 401

    ERR_IF_IPV4_INVALID_STATIC_ADDR = 402

    ERR_IF_IPV6_INVALID_STATIC_ADDR = 403

    ERR_IF_IPV4_INVALID_STATIC_PREFIX_LEN = 404

    ERR_IF_IPV6_INVALID_STATIC_PREFIX_LEN = 405

    ERR_IF_IPV4_INVALID_DHCP_PREF_HOSTNAME = 406

    ERR_IF_IPV6_INVALID_DHCP_PREF_HOSTNAME = 407

    ERR_IF_EAP_INVALID_IDENTITY = 408

    ERR_IF_EAP_INVALID_PASSWORD = 409

    ERR_IF_EAP_INVALID_CLIENT_CERT = 410

    ERR_IF_EAP_INVALID_CLIENT_PRIV_KEY_OR_PWD = 411

    ERR_IF_EAP_CLIENT_CERT_PRIV_KEY_MISMATCH = 412

    ERR_IF_EAP_INVALID_CA_CERT = 413

    ERR_IF_EAP_CA_CERT_VERIFY_FAILED = 414

    ERR_IF_EAP_INVALID_AUTH_SERVER_NAME = 415

    ERR_ETH_IF_UNSUPPORTED_LINKMODE = 500

    ERR_WLAN_IF_INVALID_SSID = 600

    ERR_WLAN_IF_INVALID_BSSID = 601

    ERR_WLAN_IF_INVALID_PSK = 602

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.net.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.net.Info, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.net.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.net.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.net.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.net.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getPortForwardingProtocolMappings(Interface.Method):
        name = 'getPortForwardingProtocolMappings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.net.PortForwardingProtocolMapping.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.net.PortForwardingProtocolMapping, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Net, self).__init__(target, agent)
        self.getInfo = Net._getInfo(self)
        self.getSettings = Net._getSettings(self)
        self.setSettings = Net._setSettings(self)
        self.getPortForwardingProtocolMappings = Net._getPortForwardingProtocolMappings(self)
