// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class WirelessInterfaceSettings : ICloneable {
    public object Clone() {
      WirelessInterfaceSettings copy = new WirelessInterfaceSettings();
      copy.ssid = this.ssid;
      copy.authentication = this.authentication;
      copy.psk = this.psk;
      copy.eap = this.eap;
      copy.bssid = this.bssid;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["ssid"] = this.ssid;
      json["authentication"] = (int)this.authentication;
      json["psk"] = this.psk;
      json["eap"] = this.eap.Encode();
      json["bssid"] = this.bssid;
      return json;
    }

    public static WirelessInterfaceSettings Decode(LightJson.JsonObject json, Agent agent) {
      WirelessInterfaceSettings inst = new WirelessInterfaceSettings();
      inst.ssid = (string)json["ssid"];
      inst.authentication = (Com.Raritan.Idl.net.AuthenticationMode)(int)json["authentication"];
      inst.psk = (string)json["psk"];
      inst.eap = Com.Raritan.Idl.net.EapSettings.Decode(json["eap"], agent);
      inst.bssid = (string)json["bssid"];
      return inst;
    }

    public string ssid = "";
    public Com.Raritan.Idl.net.AuthenticationMode authentication = Com.Raritan.Idl.net.AuthenticationMode.AUTH_NONE;
    public string psk = "";
    public Com.Raritan.Idl.net.EapSettings eap = new Com.Raritan.Idl.net.EapSettings();
    public string bssid = "";
  }
}
