# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "TestDisplay.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Display(Interface):
    idlType = "test.Display:1.0.1"

    # enumeration
    class Orientation(Enumeration):
        idlType = "test.Display_1_0_1.Orientation:1.0.0"
        values = ["NORMAL", "FLIPPED", "LEFT", "RIGHT"]

    Orientation.NORMAL = Orientation(0)
    Orientation.FLIPPED = Orientation(1)
    Orientation.LEFT = Orientation(2)
    Orientation.RIGHT = Orientation(3)

    # structure
    class Info(Structure):
        idlType = "test.Display_1_0_1.Info:1.0.0"
        elements = ["type", "address", "options", "orientation"]

        def __init__(self, type, address, options, orientation):
            typecheck.is_string(type, AssertionError)
            typecheck.is_string(address, AssertionError)
            typecheck.is_enum(orientation, raritan.rpc.test.Display.Orientation, AssertionError)

            self.type = type
            self.address = address
            self.options = options
            self.orientation = orientation

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = json['type'],
                address = json['address'],
                options = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['options']]),
                orientation = raritan.rpc.test.Display.Orientation.decode(json['orientation']),
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = self.type
            json['address'] = self.address
            json['options'] = [dict(
                key = k,
                value = v)
                for k, v in self.options.items()]
            json['orientation'] = raritan.rpc.test.Display.Orientation.encode(self.orientation)
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Display.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.test.Display.Info, DecodeException)
            return _ret_

    class _testSequence(Interface.Method):
        name = 'testSequence'

        @staticmethod
        def encode(cycleTime_ms):
            typecheck.is_int(cycleTime_ms, AssertionError)
            args = {}
            args['cycleTime_ms'] = cycleTime_ms
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    # enumeration
    class TestStatus(Enumeration):
        idlType = "test.Display_1_0_1.TestStatus:1.0.0"
        values = ["TEST_IDLE", "TEST_BUSY", "TEST_PASSED", "TEST_FAILED"]

    TestStatus.TEST_IDLE = TestStatus(0)
    TestStatus.TEST_BUSY = TestStatus(1)
    TestStatus.TEST_PASSED = TestStatus(2)
    TestStatus.TEST_FAILED = TestStatus(3)

    class _enterTestMode(Interface.Method):
        name = 'enterTestMode'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getTestStatus(Interface.Method):
        name = 'getTestStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Display.TestStatus.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.test.Display.TestStatus, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Display, self).__init__(target, agent)
        self.getInfo = Display._getInfo(self)
        self.testSequence = Display._testSequence(self)
        self.enterTestMode = Display._enterTestMode(self)
        self.getTestStatus = Display._getTestStatus(self)

#
# Section generated by IdlC from "TestUnit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Unit(Interface):
    idlType = "test.Unit:1.0.2"

    class _getDisplays(Interface.Method):
        name = 'getDisplays'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.test.Display, DecodeException)
            return _ret_

    class _getButtonStates(Interface.Method):
        name = 'getButtonStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_bool(x0, DecodeException)
            return _ret_

    class _setBuzzer(Interface.Method):
        name = 'setBuzzer'

        @staticmethod
        def encode(isOn):
            typecheck.is_bool(isOn, AssertionError)
            args = {}
            args['isOn'] = isOn
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _resetAllSlaveControllers(Interface.Method):
        name = 'resetAllSlaveControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _triggerSlaveControllerWatchdog(Interface.Method):
        name = 'triggerSlaveControllerWatchdog'

        @staticmethod
        def encode(rs485Addr):
            typecheck.is_int(rs485Addr, AssertionError)
            args = {}
            args['rs485Addr'] = rs485Addr
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(Unit, self).__init__(target, agent)
        self.getDisplays = Unit._getDisplays(self)
        self.getButtonStates = Unit._getButtonStates(self)
        self.setBuzzer = Unit._setBuzzer(self)
        self.resetAllSlaveControllers = Unit._resetAllSlaveControllers(self)
        self.triggerSlaveControllerWatchdog = Unit._triggerSlaveControllerWatchdog(self)

#
# Section generated by IdlC from "testrpc.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# structure
class Result(Structure):
    idlType = "test.Result:1.0.0"
    elements = ["code", "errtext"]

    def __init__(self, code, errtext):
        typecheck.is_int(code, AssertionError)
        typecheck.is_string(errtext, AssertionError)

        self.code = code
        self.errtext = errtext

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            code = json['code'],
            errtext = json['errtext'],
        )
        return obj

    def encode(self):
        json = {}
        json['code'] = self.code
        json['errtext'] = self.errtext
        return json

# interface
class Control(Interface):
    idlType = "test.Control:1.0.0"

    class _isTestMode(Interface.Method):
        name = 'isTestMode'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setTestMode(Interface.Method):
        name = 'setTestMode'

        @staticmethod
        def encode(isTestModeOn):
            typecheck.is_bool(isTestModeOn, AssertionError)
            args = {}
            args['isTestModeOn'] = isTestModeOn
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(Control, self).__init__(target, agent)
        self.isTestMode = Control._isTestMode(self)
        self.setTestMode = Control._setTestMode(self)

# interface
class RS232Serial(Interface):
    idlType = "test.RS232Serial:1.0.0"

    class _getDeviceFiles(Interface.Method):
        name = 'getDeviceFiles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _testLoop1(Interface.Method):
        name = 'testLoop1'

        @staticmethod
        def encode(devfile):
            typecheck.is_string(devfile, AssertionError)
            args = {}
            args['devfile'] = devfile
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Result.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.test.Result, DecodeException)
            return _ret_

    class _testLoop2(Interface.Method):
        name = 'testLoop2'

        @staticmethod
        def encode(devfile):
            typecheck.is_string(devfile, AssertionError)
            args = {}
            args['devfile'] = devfile
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Result.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.test.Result, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(RS232Serial, self).__init__(target, agent)
        self.getDeviceFiles = RS232Serial._getDeviceFiles(self)
        self.testLoop1 = RS232Serial._testLoop1(self)
        self.testLoop2 = RS232Serial._testLoop2(self)

# interface
class FeatSerial(Interface):
    idlType = "test.FeatSerial:1.0.0"

    OK = 0

    ERR_NO_TEST_MODE = 1

    ERR_INVAL_PORT_NUM = 2

    ERR_TEST_FAILED = 3

    class _getNumberOfPorts(Interface.Method):
        name = 'getNumberOfPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            numPorts = rsp['numPorts']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_int(numPorts, DecodeException)
            return (_ret_, numPorts)

    class _setPower(Interface.Method):
        name = 'setPower'

        @staticmethod
        def encode(portNum, hasPower):
            typecheck.is_int(portNum, AssertionError)
            typecheck.is_bool(hasPower, AssertionError)
            args = {}
            args['portNum'] = portNum
            args['hasPower'] = hasPower
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _testLoopTxRx(Interface.Method):
        name = 'testLoopTxRx'

        @staticmethod
        def encode(portNum):
            typecheck.is_int(portNum, AssertionError)
            args = {}
            args['portNum'] = portNum
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            errstr = rsp['errstr']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_string(errstr, DecodeException)
            return (_ret_, errstr)

    class _testLoopDtrDcd(Interface.Method):
        name = 'testLoopDtrDcd'

        @staticmethod
        def encode(portNum):
            typecheck.is_int(portNum, AssertionError)
            args = {}
            args['portNum'] = portNum
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            errstr = rsp['errstr']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_string(errstr, DecodeException)
            return (_ret_, errstr)
    def __init__(self, target, agent):
        super(FeatSerial, self).__init__(target, agent)
        self.getNumberOfPorts = FeatSerial._getNumberOfPorts(self)
        self.setPower = FeatSerial._setPower(self)
        self.testLoopTxRx = FeatSerial._testLoopTxRx(self)
        self.testLoopDtrDcd = FeatSerial._testLoopDtrDcd(self)

# interface
class AuxSerial(Interface):
    idlType = "test.AuxSerial:1.0.0"

    OK = 0

    ERR_NO_TEST_MODE = 1

    ERR_INVAL_PORT_NUM = 2

    ERR_TEST_FAILED = 3

    class _getNumberOfPorts(Interface.Method):
        name = 'getNumberOfPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            numPorts = rsp['numPorts']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_int(numPorts, DecodeException)
            return (_ret_, numPorts)

    class _testLoop(Interface.Method):
        name = 'testLoop'

        @staticmethod
        def encode(portNum):
            typecheck.is_int(portNum, AssertionError)
            args = {}
            args['portNum'] = portNum
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            errstr = rsp['errstr']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_string(errstr, DecodeException)
            return (_ret_, errstr)
    def __init__(self, target, agent):
        super(AuxSerial, self).__init__(target, agent)
        self.getNumberOfPorts = AuxSerial._getNumberOfPorts(self)
        self.testLoop = AuxSerial._testLoop(self)

# interface
class Ethernet(Interface):
    idlType = "test.Ethernet:1.0.0"

    class _getDevices(Interface.Method):
        name = 'getDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    # enumeration
    class Speed(Enumeration):
        idlType = "test.Ethernet.Speed:1.0.0"
        values = ["SPD_10", "SPD_100", "SPD_1000"]

    Speed.SPD_10 = Speed(0)
    Speed.SPD_100 = Speed(1)
    Speed.SPD_1000 = Speed(2)

    # enumeration
    class Duplex(Enumeration):
        idlType = "test.Ethernet.Duplex:1.0.0"
        values = ["DPX_HALF", "DPX_FULL"]

    Duplex.DPX_HALF = Duplex(0)
    Duplex.DPX_FULL = Duplex(1)

    class _setParameters(Interface.Method):
        name = 'setParameters'

        @staticmethod
        def encode(device, speed, duplex, isAutoNeg):
            typecheck.is_string(device, AssertionError)
            typecheck.is_enum(speed, raritan.rpc.test.Ethernet.Speed, AssertionError)
            typecheck.is_enum(duplex, raritan.rpc.test.Ethernet.Duplex, AssertionError)
            typecheck.is_bool(isAutoNeg, AssertionError)
            args = {}
            args['device'] = device
            args['speed'] = raritan.rpc.test.Ethernet.Speed.encode(speed)
            args['duplex'] = raritan.rpc.test.Ethernet.Duplex.encode(duplex)
            args['isAutoNeg'] = isAutoNeg
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Ethernet, self).__init__(target, agent)
        self.getDevices = Ethernet._getDevices(self)
        self.setParameters = Ethernet._setParameters(self)
